/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser;

import java.util.Set;
import me.snowdrop.licenses.sanitiser.LicenseSanitiser;
import me.snowdrop.licenses.sanitiser.exceptions.LicenseException;
import me.snowdrop.licenses.utils.JsonUtils;
import me.snowdrop.licenses.xml.DependencyElement;

public class ExceptionLicenseSanitiser
implements LicenseSanitiser {
    private final Set<LicenseException> exceptions;
    private final LicenseSanitiser next;

    public ExceptionLicenseSanitiser(String exceptionsFilePath, LicenseSanitiser next) {
        this.exceptions = JsonUtils.loadJsonToSet(exceptionsFilePath, LicenseException::new);
        this.next = next;
    }

    @Override
    public DependencyElement fix(DependencyElement dependencyElement) {
        return this.exceptions.stream().filter(exception -> exception.matches(dependencyElement)).findFirst().map(exception -> new DependencyElement(dependencyElement, exception.getLicenses())).orElseGet(() -> this.next.fix(dependencyElement));
    }
}

