/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser.provider;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import me.snowdrop.licenses.LicensesGeneratorException;
import me.snowdrop.licenses.sanitiser.provider.ExternalLicenseDto;
import me.snowdrop.licenses.sanitiser.provider.ExternalLicensesDto;
import me.snowdrop.licenses.xml.LicenseElement;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class ExternalLicenseProvider {
    private static final Logger logger = Logger.getLogger(ExternalLicenseProvider.class.getSimpleName());
    private final Client client;
    private final String licenseServiceUrl;

    public ExternalLicenseProvider(String licenseServiceUrl) {
        this.licenseServiceUrl = licenseServiceUrl;
        logger.info("Using license service " + licenseServiceUrl);
        ClientBuilder clientBuilder = ResteasyClientBuilder.newBuilder();
        this.client = clientBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<LicenseElement> getLicenses(String gav) {
        try (Response response = this.client.target(this.licenseServiceUrl).queryParam("gav", new Object[]{gav}).request().get();){
            if (response.getStatus() != 200) {
                logger.info("Unable to get license information for " + gav + " from license service: error " + response.getStatus());
                return Collections.emptySet();
            }
            logger.info("Got license information for " + gav + " from license service");
            String content = (String)response.readEntity(String.class);
            Set<LicenseElement> licenses = this.parseLicenses(content).stream().flatMap(dto -> dto.getLicenses().stream()).map(ExternalLicenseDto::toLicenseElement).collect(Collectors.toSet());
            if (!this.areValid(licenses)) return Collections.emptySet();
            Set<LicenseElement> set = licenses;
            return set;
        }
        catch (LicensesGeneratorException e) {
            throw new RuntimeException("Error getting license for gav: " + gav, e);
        }
    }

    private boolean areValid(Collection<LicenseElement> licenses) {
        return licenses.stream().allMatch(LicenseElement::isValid);
    }

    private List<ExternalLicensesDto> parseLicenses(String content) throws LicensesGeneratorException {
        ObjectMapper mapper = new ObjectMapper();
        TypeFactory typeFactory = mapper.getTypeFactory();
        CollectionType licenseList = typeFactory.constructCollectionType(List.class, ExternalLicensesDto.class);
        try {
            return (List)mapper.readValue(content, (JavaType)licenseList);
        }
        catch (IOException e) {
            throw new LicensesGeneratorException("Unable to parse EAP licenses: " + content, e);
        }
    }
}

