/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.autoconfigure;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.io.File;
import javax.jms.Message;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import me.snowdrop.boot.narayana.autoconfigure.NarayanaBeanFactoryPostProcessor;
import me.snowdrop.boot.narayana.core.jdbc.GenericXADataSourceWrapper;
import me.snowdrop.boot.narayana.core.jdbc.PooledXADataSourceWrapper;
import me.snowdrop.boot.narayana.core.jms.NarayanaXAConnectionFactoryWrapper;
import me.snowdrop.boot.narayana.core.properties.NarayanaProperties;
import me.snowdrop.boot.narayana.core.properties.NarayanaPropertiesInitializer;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.autoconfigure.transaction.jta.JtaAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.jta.JtaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.XADataSourceWrapper;
import org.springframework.boot.jms.XAConnectionFactoryWrapper;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={JtaProperties.class, NarayanaProperties.class})
@ConditionalOnProperty(prefix="spring.jta", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Transaction.class, JtaTransactionManager.class, XAResourceRecoveryRegistry.class, UserTransaction.class})
@ConditionalOnMissingBean(value={PlatformTransactionManager.class})
@AutoConfigureBefore(value={JtaAutoConfiguration.class})
public class NarayanaConfiguration {
    private final JtaProperties jtaProperties;
    private final TransactionManagerCustomizers transactionManagerCustomizers;

    public NarayanaConfiguration(JtaProperties jtaProperties, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        this.jtaProperties = jtaProperties;
        this.transactionManagerCustomizers = (TransactionManagerCustomizers)transactionManagerCustomizers.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public static NarayanaBeanFactoryPostProcessor narayanaBeanFactoryPostProcessor() {
        return new NarayanaBeanFactoryPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public NarayanaPropertiesInitializer narayanaPropertiesInitializer(NarayanaProperties properties) {
        this.initLogDir(properties);
        this.initTransactionManagerId(properties);
        return new NarayanaPropertiesInitializer(properties);
    }

    @Bean
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public javax.transaction.UserTransaction narayanaUserTransaction() {
        return UserTransaction.userTransaction();
    }

    @Bean
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public TransactionManager narayanaTransactionManager() {
        return com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    @Bean
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public TransactionSynchronizationRegistry narayanaTransactionSynchronizationRegistry() {
        return jtaPropertyManager.getJTAEnvironmentBean().getTransactionSynchronizationRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    public JtaTransactionManager transactionManager(javax.transaction.UserTransaction userTransaction, TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager(userTransaction, transactionManager);
        jtaTransactionManager.setTransactionSynchronizationRegistry(transactionSynchronizationRegistry);
        if (this.transactionManagerCustomizers != null) {
            this.transactionManagerCustomizers.customize((PlatformTransactionManager)jtaTransactionManager);
        }
        return jtaTransactionManager;
    }

    @Bean(destroyMethod="stop")
    @DependsOn(value={"narayanaPropertiesInitializer"})
    @ConditionalOnMissingBean
    public RecoveryManagerService recoveryManagerService() {
        RecoveryManager.delayRecoveryManagerThread();
        RecoveryManagerService recoveryManagerService = new RecoveryManagerService();
        recoveryManagerService.create();
        recoveryManagerService.start();
        return recoveryManagerService;
    }

    @Bean
    @DependsOn(value={"recoveryManagerService"})
    @ConditionalOnMissingBean
    public XARecoveryModule xaRecoveryModule() {
        return XARecoveryModule.getRegisteredXARecoveryModule();
    }

    private void initLogDir(NarayanaProperties properties) {
        if (!StringUtils.isEmpty((Object)properties.getLogDir())) {
            return;
        }
        if (!StringUtils.isEmpty((Object)this.jtaProperties.getLogDir())) {
            properties.setLogDir(this.jtaProperties.getLogDir());
        } else {
            properties.setLogDir(this.getLogDir().getAbsolutePath());
        }
    }

    private void initTransactionManagerId(NarayanaProperties properties) {
        if (!StringUtils.isEmpty((Object)properties.getTransactionManagerId())) {
            return;
        }
        if (!StringUtils.isEmpty((Object)this.jtaProperties.getTransactionManagerId())) {
            properties.setTransactionManagerId(this.jtaProperties.getTransactionManagerId());
        }
    }

    private File getLogDir() {
        if (StringUtils.hasLength((String)this.jtaProperties.getLogDir())) {
            return new File(this.jtaProperties.getLogDir());
        }
        File home = new ApplicationHome().getDir();
        return new File(home, "transaction-logs");
    }

    @Configuration
    @ConditionalOnClass(value={Message.class})
    static class NarayanaJmsConfiguration {
        NarayanaJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XAConnectionFactoryWrapper.class})
        public XAConnectionFactoryWrapper xaConnectionFactoryWrapper(TransactionManager transactionManager, XARecoveryModule xaRecoveryModule, NarayanaProperties narayanaProperties) {
            return new NarayanaXAConnectionFactoryWrapper(transactionManager, xaRecoveryModule, narayanaProperties);
        }
    }

    @ConditionalOnProperty(name={"narayana.dbcp.enabled"}, havingValue="true")
    static class PooledJdbcConfiguration {
        PooledJdbcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XADataSourceWrapper.class})
        public XADataSourceWrapper xaDataSourceWrapper(NarayanaProperties narayanaProperties, XARecoveryModule xaRecoveryModule, TransactionManager transactionManager) {
            return new PooledXADataSourceWrapper(narayanaProperties, xaRecoveryModule, transactionManager);
        }
    }

    @ConditionalOnProperty(name={"narayana.dbcp.enabled"}, havingValue="false", matchIfMissing=true)
    static class GenericJdbcConfiguration {
        GenericJdbcConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XADataSourceWrapper.class})
        public XADataSourceWrapper xaDataSourceWrapper(NarayanaProperties narayanaProperties, XARecoveryModule xaRecoveryModule) {
            return new GenericXADataSourceWrapper(narayanaProperties, xaRecoveryModule);
        }
    }
}

