/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.hajdbc.Version;

public abstract class AbstractDriver
implements Driver {
    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.parse(url) != null;
    }

    protected abstract Pattern getUrlPattern();

    protected String parse(String url) {
        Matcher matcher = this.getUrlPattern().matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return Version.getMinorVersion();
    }
}

