/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseFactory;
import net.sf.hajdbc.ExecutorServiceProvider;
import net.sf.hajdbc.SynchronizationStrategy;
import net.sf.hajdbc.TransactionMode;
import net.sf.hajdbc.balancer.BalancerFactory;
import net.sf.hajdbc.cache.DatabaseMetaDataCacheFactory;
import net.sf.hajdbc.codec.DecoderFactory;
import net.sf.hajdbc.dialect.DialectFactory;
import net.sf.hajdbc.distributed.CommandDispatcherFactory;
import net.sf.hajdbc.durability.DurabilityFactory;
import net.sf.hajdbc.lock.LockManagerFactory;
import net.sf.hajdbc.management.MBeanRegistrar;
import net.sf.hajdbc.state.StateManagerFactory;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;
import net.sf.hajdbc.util.concurrent.cron.CronExpression;

public interface DatabaseClusterConfiguration<Z, D extends Database<Z>>
extends Serializable {
    public CommandDispatcherFactory getDispatcherFactory();

    public ConcurrentMap<String, D> getDatabaseMap();

    public Map<String, SynchronizationStrategy> getSynchronizationStrategyMap();

    public String getDefaultSynchronizationStrategy();

    public BalancerFactory getBalancerFactory();

    public TransactionMode getTransactionMode();

    public ExecutorServiceProvider getExecutorProvider();

    public DialectFactory getDialectFactory();

    public StateManagerFactory getStateManagerFactory();

    public DatabaseMetaDataCacheFactory getDatabaseMetaDataCacheFactory();

    public DurabilityFactory getDurabilityFactory();

    public LockManagerFactory getLockManagerFactory();

    public boolean isSequenceDetectionEnabled();

    public boolean isIdentityColumnDetectionEnabled();

    public boolean isCurrentDateEvaluationEnabled();

    public boolean isCurrentTimeEvaluationEnabled();

    public boolean isCurrentTimestampEvaluationEnabled();

    public boolean isRandEvaluationEnabled();

    public CronExpression getFailureDetectionExpression();

    public CronExpression getAutoActivationExpression();

    public ThreadFactory getThreadFactory();

    public DecoderFactory getDecoderFactory();

    public MBeanRegistrar<Z, D> getMBeanRegistrar();

    public TransactionIdentifierFactory<? extends Object> getTransactionIdentifierFactory();

    public boolean isEmptyClusterAllowed();

    public DatabaseFactory<Z, D> getDatabaseFactory();
}

