/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import net.sf.hajdbc.ExceptionFactory;
import net.sf.hajdbc.util.Matcher;
import net.sf.hajdbc.util.ServiceLoaders;

public enum ExceptionType implements Matcher<ExceptionFactory>
{
    SQL(SQLException.class),
    XA(XAException.class);

    private final Class<? extends Exception> exceptionClass;

    private <E extends Exception> ExceptionType(Class<E> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    @Override
    public boolean matches(ExceptionFactory factory) {
        return this == factory.getType();
    }

    public <E extends Exception> ExceptionFactory<E> getExceptionFactory() {
        return ServiceLoaders.findRequiredService(this, ExceptionFactory.class);
    }

    public static <E extends Exception> ExceptionFactory<E> getExceptionFactory(Class<E> exceptionClass) {
        for (ExceptionType type : ExceptionType.values()) {
            if (!type.exceptionClass.equals(exceptionClass)) continue;
            return type.getExceptionFactory();
        }
        throw new IllegalArgumentException(exceptionClass.getName());
    }
}

