/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc;

import net.sf.hajdbc.TableProperties;
import net.sf.hajdbc.TriggerEvent;
import net.sf.hajdbc.TriggerTime;

public interface TriggerSupport {
    public String getTriggerRowAlias(TriggerTime var1);

    public String getCreateTriggerSQL(String var1, TableProperties var2, TriggerEvent var3, String var4);

    public String getDropTriggerSQL(String var1, TableProperties var2);

    public static enum TriggerTimeEnum implements TriggerTime
    {
        BEFORE("OLD"),
        AFTER("NEW");

        private final String alias;

        private TriggerTimeEnum(String alias) {
            this.alias = alias;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }
    }

    public static enum TriggerEventEnum implements TriggerEvent
    {
        INSERT(TriggerTimeEnum.AFTER, true),
        UPDATE(TriggerTimeEnum.AFTER, false),
        DELETE(TriggerTimeEnum.BEFORE, null);

        private final TriggerTime time;
        private final Boolean value;

        private TriggerEventEnum(TriggerTime time, Boolean value) {
            this.time = time;
            this.value = value;
        }

        @Override
        public TriggerTime getTime() {
            return this.time;
        }

        @Override
        public Boolean getValue() {
            return this.value;
        }

        static TriggerEvent valueOf(Boolean value) {
            for (TriggerEventEnum event : TriggerEventEnum.values()) {
                if (!(value != null && event.value != null ? value.equals(event.value) : value == event.value)) continue;
                return event;
            }
            throw new IllegalArgumentException();
        }
    }
}

