/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.balancer;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.balancer.Balancer;

public abstract class AbstractBalancer<Z, D extends Database<Z>>
implements Balancer<Z, D> {
    protected abstract Set<D> getDatabases();

    @Override
    public Iterable<D> backups() {
        Iterator<D> databases = this.getDatabases().iterator();
        if (!databases.hasNext() || databases.next() != null && !databases.hasNext()) {
            return Collections.emptySet();
        }
        Database database = (Database)databases.next();
        if (!databases.hasNext()) {
            return Collections.singleton(database);
        }
        TreeSet<Database<Object>> backups = new TreeSet<Database<Object>>();
        backups.add(database);
        do {
            backups.add((Database<Object>)databases.next());
        } while (databases.hasNext());
        return backups;
    }

    @Override
    public Iterator<D> iterator() {
        return this.getDatabases().iterator();
    }

    @Override
    public boolean contains(Object database) {
        return this.getDatabases().contains(database);
    }

    @Override
    public boolean containsAll(Collection<?> databases) {
        return this.getDatabases().containsAll(databases);
    }

    @Override
    public boolean isEmpty() {
        return this.getDatabases().isEmpty();
    }

    @Override
    public int size() {
        return this.getDatabases().size();
    }

    @Override
    public Object[] toArray() {
        return this.getDatabases().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.getDatabases().toArray(array);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Collection)) {
            return false;
        }
        Collection set = (Collection)object;
        return this.getDatabases().equals(set);
    }

    @Override
    public int hashCode() {
        return this.getDatabases().hashCode();
    }

    public String toString() {
        return this.getDatabases().toString();
    }
}

