/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.balancer;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.balancer.AbstractBalancer;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.util.Collections;

public abstract class AbstractSetBalancer<Z, D extends Database<Z>>
extends AbstractBalancer<Z, D> {
    private final Lock lock = new ReentrantLock();
    private volatile SortedSet<D> databaseSet;

    protected AbstractSetBalancer(Set<D> databases) {
        if (databases.isEmpty()) {
            this.databaseSet = Collections.emptySortedSet();
        } else if (databases.size() == 1) {
            this.databaseSet = Collections.singletonSortedSet(databases.iterator().next());
        } else {
            TreeSet<D> set = new TreeSet<D>();
            for (Database database : databases) {
                set.add(database);
            }
            this.databaseSet = set;
        }
    }

    protected Lock getLock() {
        return this.lock;
    }

    @Override
    public <T, R, E extends Exception> R invoke(Invoker<Z, D, T, R, E> invoker, D database, T object) throws E {
        return invoker.invoke(database, object);
    }

    @Override
    public D primary() {
        try {
            return (D)((Database)this.databaseSet.first());
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    protected Set<D> getDatabases() {
        return this.databaseSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object database) {
        this.lock.lock();
        try {
            boolean remove = this.databaseSet.contains(database);
            if (remove) {
                if (this.databaseSet.size() == 1) {
                    this.databaseSet = Collections.emptySortedSet();
                } else {
                    TreeSet<D> set = new TreeSet<D>(this.databaseSet);
                    set.remove(database);
                    this.databaseSet = set;
                }
                this.removed((Database)database);
            }
            boolean bl = remove;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void removed(D var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(D database) {
        this.lock.lock();
        try {
            boolean add;
            boolean bl = add = !this.databaseSet.contains(database);
            if (add) {
                if (this.databaseSet.isEmpty()) {
                    this.databaseSet = Collections.singletonSortedSet(database);
                } else {
                    TreeSet<D> set = new TreeSet<D>(this.databaseSet);
                    set.add(database);
                    this.databaseSet = set;
                }
                this.added(database);
            }
            boolean bl2 = add;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void added(D var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends D> databases) {
        this.lock.lock();
        try {
            TreeSet<D> addSet = new TreeSet<D>(this.databaseSet);
            boolean added = addSet.addAll(databases);
            if (added) {
                TreeSet<D> removeSet = new TreeSet<D>(addSet);
                removeSet.removeAll(this.databaseSet);
                this.databaseSet = addSet;
                for (Database database : removeSet) {
                    this.added(database);
                }
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> databases) {
        this.lock.lock();
        try {
            TreeSet<D> removeSet = new TreeSet<D>(this.databaseSet);
            boolean removed = removeSet.removeAll(databases);
            if (removed) {
                TreeSet<D> retainSet = new TreeSet<D>(this.databaseSet);
                retainSet.retainAll(databases);
                this.databaseSet = removeSet;
                for (Database database : removeSet) {
                    this.removed(database);
                }
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> databases) {
        this.lock.lock();
        try {
            TreeSet<D> retainSet = new TreeSet<D>(this.databaseSet);
            boolean retained = retainSet.retainAll(databases);
            if (retained) {
                TreeSet<D> removeSet = new TreeSet<D>(this.databaseSet);
                removeSet.removeAll(databases);
                this.databaseSet = retainSet;
                for (Database database : removeSet) {
                    this.removed(database);
                }
            }
            boolean bl = retained;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            if (!this.databaseSet.isEmpty()) {
                this.databaseSet = Collections.emptySortedSet();
                this.cleared();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void cleared();
}

