/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.balancer.load;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.balancer.AbstractBalancer;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.util.Collections;

public class LoadBalancer<Z, D extends Database<Z>>
extends AbstractBalancer<Z, D> {
    private final Lock lock = new ReentrantLock();
    private volatile SortedMap<D, AtomicInteger> databaseMap = Collections.emptySortedMap();
    private Comparator<Map.Entry<D, AtomicInteger>> comparator = new Comparator<Map.Entry<D, AtomicInteger>>(){

        @Override
        public int compare(Map.Entry<D, AtomicInteger> mapEntry1, Map.Entry<D, AtomicInteger> mapEntry2) {
            int weight2;
            Database database1 = (Database)mapEntry1.getKey();
            Database database2 = (Database)mapEntry2.getKey();
            float load1 = mapEntry1.getValue().get();
            float load2 = mapEntry2.getValue().get();
            int weight1 = database1.getWeight();
            if (weight1 == (weight2 = database2.getWeight())) {
                return Float.compare(load1, load2);
            }
            float weightedLoad1 = weight1 != 0 ? load1 / (float)weight1 : Float.POSITIVE_INFINITY;
            float weightedLoad2 = weight2 != 0 ? load2 / (float)weight2 : Float.POSITIVE_INFINITY;
            return Float.compare(weightedLoad1, weightedLoad2);
        }
    };

    public LoadBalancer(Set<D> databases) {
        if (databases.isEmpty()) {
            this.databaseMap = Collections.emptySortedMap();
        } else if (databases.size() == 1) {
            this.databaseMap = Collections.singletonSortedMap(databases.iterator().next(), new AtomicInteger(1));
        } else {
            TreeMap<D, AtomicInteger> map = new TreeMap<D, AtomicInteger>();
            for (Database database : databases) {
                map.put(database, new AtomicInteger(1));
            }
            this.databaseMap = map;
        }
    }

    @Override
    public D primary() {
        try {
            return (D)((Database)this.databaseMap.firstKey());
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    protected Set<D> getDatabases() {
        return this.databaseMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends D> databases) {
        this.lock.lock();
        try {
            TreeMap<D, AtomicInteger> addMap = new TreeMap<D, AtomicInteger>(this.databaseMap);
            boolean added = false;
            for (Database database : databases) {
                added = addMap.put(database, new AtomicInteger(1)) == null || added;
            }
            if (added) {
                this.databaseMap = addMap;
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> databases) {
        this.lock.lock();
        try {
            TreeMap<D, AtomicInteger> map = new TreeMap<D, AtomicInteger>(this.databaseMap);
            boolean removed = map.keySet().removeAll(databases);
            if (removed) {
                this.databaseMap = map;
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> databases) {
        this.lock.lock();
        try {
            TreeMap<D, AtomicInteger> map = new TreeMap<D, AtomicInteger>(this.databaseMap);
            boolean retained = map.keySet().retainAll(databases);
            if (retained) {
                this.databaseMap = map;
            }
            boolean bl = retained;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            if (!this.databaseMap.isEmpty()) {
                this.databaseMap = new TreeMap<D, AtomicInteger>();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object database) {
        this.lock.lock();
        try {
            boolean remove = this.databaseMap.containsKey(database);
            if (remove) {
                if (this.databaseMap.size() == 1) {
                    this.databaseMap = Collections.emptySortedMap();
                } else {
                    TreeMap<D, AtomicInteger> map = new TreeMap<D, AtomicInteger>(this.databaseMap);
                    map.remove(database);
                    this.databaseMap = map;
                }
            }
            boolean bl = remove;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public D next() {
        Set<Map.Entry<D, AtomicInteger>> entrySet = this.databaseMap.entrySet();
        return (D)(!entrySet.isEmpty() ? (Database)java.util.Collections.min(entrySet, this.comparator).getKey() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(D database) {
        this.lock.lock();
        try {
            boolean add;
            boolean bl = add = !this.databaseMap.containsKey(database);
            if (add) {
                AtomicInteger load = new AtomicInteger(1);
                if (this.databaseMap.isEmpty()) {
                    this.databaseMap = Collections.singletonSortedMap(database, load);
                } else {
                    TreeMap<D, AtomicInteger> map = new TreeMap<D, AtomicInteger>(this.databaseMap);
                    map.put(database, load);
                    this.databaseMap = map;
                }
            }
            boolean bl2 = add;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, R, E extends Exception> R invoke(Invoker<Z, D, T, R, E> invoker, D database, T object) throws E {
        AtomicInteger load = (AtomicInteger)this.databaseMap.get(database);
        if (load != null) {
            load.incrementAndGet();
        }
        try {
            R r = invoker.invoke(database, object);
            return r;
        }
        finally {
            if (load != null) {
                load.decrementAndGet();
            }
        }
    }
}

