/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.balancer.random;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.balancer.AbstractSetBalancer;

public class RandomBalancer<P, D extends Database<P>>
extends AbstractSetBalancer<P, D> {
    private volatile List<D> databaseList;
    private Random random = new Random();

    public RandomBalancer(Set<D> databases) {
        super(databases);
        int total = 0;
        for (Database database : databases) {
            total += database.getWeight();
        }
        ArrayList<D> list = new ArrayList<D>(total);
        for (Database database : databases) {
            int weight = database.getWeight();
            for (int i = 0; i < weight; ++i) {
                list.add(database);
            }
        }
        this.databaseList = list;
    }

    @Override
    public D next() {
        List<D> list = this.databaseList;
        return (D)(!list.isEmpty() ? (Database)list.get(this.random.nextInt(list.size())) : this.primary());
    }

    @Override
    protected void added(D database) {
        int weight = database.getWeight();
        if (weight > 0) {
            ArrayList<D> list = new ArrayList<D>(this.databaseList.size() + weight);
            list.addAll(this.databaseList);
            for (int i = 0; i < weight; ++i) {
                list.add(database);
            }
            this.databaseList = list;
        }
    }

    @Override
    protected void removed(D database) {
        int weight = database.getWeight();
        if (weight > 0) {
            ArrayList<D> list = new ArrayList<D>(this.databaseList.size() - weight);
            int index = this.databaseList.indexOf(database);
            list.addAll(this.databaseList.subList(0, index));
            list.addAll(this.databaseList.subList(index + weight, this.databaseList.size()));
            this.databaseList = list;
        }
    }

    @Override
    protected void cleared() {
        this.databaseList = Collections.emptyList();
    }
}

