/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.balancer.roundrobin;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.balancer.AbstractSetBalancer;

public class RoundRobinBalancer<P, D extends Database<P>>
extends AbstractSetBalancer<P, D> {
    private Queue<D> databaseQueue = new LinkedList<D>();

    public RoundRobinBalancer(Set<D> databases) {
        super(databases);
        for (Database database : databases) {
            this.added(database);
        }
    }

    @Override
    protected void added(D database) {
        int weight = database.getWeight();
        for (int i = 0; i < weight; ++i) {
            this.databaseQueue.add(database);
        }
    }

    @Override
    protected void removed(D database) {
        int weight = database.getWeight();
        for (int i = 0; i < weight; ++i) {
            this.databaseQueue.remove(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D next() {
        this.getLock().lock();
        try {
            if (this.databaseQueue.isEmpty()) {
                Object d = this.primary();
                return d;
            }
            if (this.databaseQueue.size() == 1) {
                Database database = (Database)this.databaseQueue.element();
                return (D)database;
            }
            Database database = (Database)this.databaseQueue.remove();
            this.databaseQueue.add(database);
            Database database2 = database;
            return (D)database2;
        }
        finally {
            this.getLock().unlock();
        }
    }

    @Override
    protected void cleared() {
        this.databaseQueue.clear();
    }
}

