/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.balancer.simple;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.balancer.AbstractSetBalancer;

public class SimpleBalancer<Z, D extends Database<Z>>
extends AbstractSetBalancer<Z, D> {
    private volatile D nextDatabase = null;
    private Comparator<D> comparator = new Comparator<D>(){

        @Override
        public int compare(D database1, D database2) {
            return database1.getWeight() - database2.getWeight();
        }
    };

    public SimpleBalancer(Set<D> databases) {
        super(databases);
        this.reset();
    }

    @Override
    public D next() {
        return this.nextDatabase;
    }

    @Override
    protected void added(D database) {
        this.reset();
    }

    @Override
    protected void removed(D database) {
        this.reset();
    }

    private void reset() {
        Set databaseSet = this.getDatabases();
        this.nextDatabase = databaseSet.isEmpty() ? null : (Database)Collections.max(databaseSet, this.comparator);
    }

    @Override
    protected void cleared() {
        this.nextDatabase = null;
    }
}

