/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.cache;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hajdbc.DatabaseProperties;
import net.sf.hajdbc.QualifiedName;
import net.sf.hajdbc.QualifiedNameFactory;
import net.sf.hajdbc.SequenceProperties;
import net.sf.hajdbc.TableProperties;
import net.sf.hajdbc.dialect.Dialect;

public abstract class AbstractDatabaseProperties
implements DatabaseProperties {
    protected final QualifiedNameFactory nameFactory;
    private final boolean supportsSelectForUpdate;
    private final boolean locatorsUpdateCopy;

    public AbstractDatabaseProperties(DatabaseMetaData metaData, Dialect dialect) throws SQLException {
        this.supportsSelectForUpdate = metaData.supportsSelectForUpdate();
        this.locatorsUpdateCopy = metaData.locatorsUpdateCopy();
        this.nameFactory = dialect.createQualifiedNameFactory(metaData, dialect.createIdentifierNormalizer(metaData));
    }

    @Override
    public final boolean supportsSelectForUpdate() throws SQLException {
        return this.supportsSelectForUpdate;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return this.locatorsUpdateCopy;
    }

    @Override
    public final Collection<TableProperties> getTables() throws SQLException {
        return this.tables().values();
    }

    protected abstract Map<QualifiedName, TableProperties> tables() throws SQLException;

    @Override
    public final Collection<SequenceProperties> getSequences() throws SQLException {
        return this.sequences().values();
    }

    protected abstract Map<QualifiedName, SequenceProperties> sequences() throws SQLException;

    @Override
    public final TableProperties findTable(String table) throws SQLException {
        return this.find(this.tables(), table, this.defaultSchemas());
    }

    @Override
    public final SequenceProperties findSequence(String sequence) throws SQLException {
        return this.find(this.sequences(), sequence, this.defaultSchemas());
    }

    private <T> T find(Map<QualifiedName, T> map, String raw, List<String> defaultSchemaList) throws SQLException {
        QualifiedName name = this.nameFactory.parse(raw);
        T properties = map.get(name);
        if (properties == null && name.getSchema() == null) {
            Iterator<String> schemas = defaultSchemaList.iterator();
            while (properties == null && schemas.hasNext()) {
                properties = map.get(this.nameFactory.createQualifiedName(schemas.next(), raw));
            }
        }
        return properties;
    }

    protected abstract List<String> defaultSchemas() throws SQLException;

    @Override
    public String findType(int precision, int ... types) throws SQLException {
        Map<Integer, Map.Entry<String, Integer>> map = this.types();
        for (int type : types) {
            Map.Entry<String, Integer> entry = map.get(type);
            if (entry == null) continue;
            String name = entry.getKey();
            Integer maxPrecision = entry.getValue();
            if (maxPrecision != null) {
                String qualifier = "(" + (precision == 0 ? maxPrecision : precision) + ")";
                return name.contains("()") ? name.replace("()", qualifier) : name + qualifier;
            }
            return name;
        }
        throw new SQLException("No native type found for " + Arrays.asList(new int[][]{types}));
    }

    protected abstract Map<Integer, Map.Entry<String, Integer>> types() throws SQLException;
}

