/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.cache.eager;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DatabaseProperties;
import net.sf.hajdbc.cache.DatabaseMetaDataCache;
import net.sf.hajdbc.cache.eager.EagerDatabaseProperties;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.util.Resources;

public class EagerDatabaseMetaDataCache<Z, D extends Database<Z>>
implements DatabaseMetaDataCache<Z, D> {
    private final Map<D, DatabaseProperties> map = new TreeMap<D, DatabaseProperties>();
    private final DatabaseCluster<Z, D> cluster;

    public EagerDatabaseMetaDataCache(DatabaseCluster<Z, D> cluster) {
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws SQLException {
        TreeMap<Database, DatabaseProperties> map = new TreeMap<Database, DatabaseProperties>();
        for (Database database : this.cluster.getBalancer()) {
            Connection connection = database.connect(database.createConnectionSource(), database.decodePassword(this.cluster.getDecoder()));
            try {
                map.put(database, this.createDatabaseProperties(connection));
            }
            finally {
                Resources.close(connection);
            }
        }
        Map<D, DatabaseProperties> map2 = this.map;
        synchronized (map2) {
            this.map.clear();
            this.map.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseProperties getDatabaseProperties(D database, Connection connection) throws SQLException {
        Map<D, DatabaseProperties> map = this.map;
        synchronized (map) {
            DatabaseProperties properties = this.map.get(database);
            if (properties == null) {
                properties = this.createDatabaseProperties(connection);
                this.map.put(database, properties);
            }
            return properties;
        }
    }

    private DatabaseProperties createDatabaseProperties(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        Dialect dialect = this.cluster.getDialect();
        return new EagerDatabaseProperties(metaData, dialect);
    }
}

