/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.cache.eager;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.hajdbc.QualifiedName;
import net.sf.hajdbc.SequenceProperties;
import net.sf.hajdbc.SequenceSupport;
import net.sf.hajdbc.TableProperties;
import net.sf.hajdbc.cache.AbstractDatabaseProperties;
import net.sf.hajdbc.cache.eager.EagerTableProperties;
import net.sf.hajdbc.dialect.Dialect;

public class EagerDatabaseProperties
extends AbstractDatabaseProperties {
    private final Map<QualifiedName, TableProperties> tables = new HashMap<QualifiedName, TableProperties>();
    private final Map<QualifiedName, SequenceProperties> sequences = new HashMap<QualifiedName, SequenceProperties>();
    private final List<String> defaultSchemas;
    private final Map<Integer, Map.Entry<String, Integer>> types;

    public EagerDatabaseProperties(DatabaseMetaData metaData, Dialect dialect) throws SQLException {
        super(metaData, dialect);
        Collection<QualifiedName> tables = dialect.getTables(metaData, this.nameFactory);
        for (QualifiedName table : tables) {
            EagerTableProperties properties = new EagerTableProperties(table, metaData, dialect, this.nameFactory);
            this.tables.put((QualifiedName)properties.getName(), properties);
        }
        List<String> defaultSchemaList = dialect.getDefaultSchemas(metaData);
        this.defaultSchemas = new ArrayList<String>(defaultSchemaList);
        SequenceSupport support = dialect.getSequenceSupport();
        if (support != null) {
            for (SequenceProperties sequence : support.getSequences(metaData, support.createSequencePropertiesFactory(this.nameFactory))) {
                this.sequences.put((QualifiedName)sequence.getName(), sequence);
            }
        }
        this.types = dialect.getTypes(metaData);
    }

    @Override
    protected List<String> defaultSchemas() {
        return this.defaultSchemas;
    }

    @Override
    protected Map<QualifiedName, SequenceProperties> sequences() {
        return this.sequences;
    }

    @Override
    protected Map<QualifiedName, TableProperties> tables() {
        return this.tables;
    }

    @Override
    protected Map<Integer, Map.Entry<String, Integer>> types() {
        return this.types;
    }
}

