/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.cache.eager;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import net.sf.hajdbc.ColumnProperties;
import net.sf.hajdbc.ForeignKeyConstraint;
import net.sf.hajdbc.IdentifierNormalizer;
import net.sf.hajdbc.QualifiedName;
import net.sf.hajdbc.QualifiedNameFactory;
import net.sf.hajdbc.UniqueConstraint;
import net.sf.hajdbc.UniqueConstraintFactory;
import net.sf.hajdbc.cache.AbstractTableProperties;
import net.sf.hajdbc.dialect.Dialect;

public class EagerTableProperties
extends AbstractTableProperties {
    private Map<String, ColumnProperties> columnMap;
    private UniqueConstraint primaryKey;
    private Collection<UniqueConstraint> uniqueConstraints;
    private Collection<ForeignKeyConstraint> foreignKeyConstraints;
    private Collection<String> identityColumns;

    public EagerTableProperties(QualifiedName table, DatabaseMetaData metaData, Dialect dialect, QualifiedNameFactory factory) throws SQLException {
        super(table);
        IdentifierNormalizer normalizer = factory.getIdentifierNormalizer();
        this.columnMap = dialect.getColumns(metaData, table, dialect.createColumnPropertiesFactory(normalizer));
        UniqueConstraintFactory uniqueConstraintFactory = dialect.createUniqueConstraintFactory(normalizer);
        this.primaryKey = dialect.getPrimaryKey(metaData, table, uniqueConstraintFactory);
        this.uniqueConstraints = dialect.getUniqueConstraints(metaData, table, this.primaryKey, uniqueConstraintFactory);
        this.foreignKeyConstraints = dialect.getForeignKeyConstraints(metaData, table, dialect.createForeignKeyConstraintFactory(factory));
        this.identityColumns = dialect.getIdentityColumns(this.columnMap.values());
    }

    @Override
    protected Map<String, ColumnProperties> getColumnMap() {
        return this.columnMap;
    }

    @Override
    public UniqueConstraint getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public Collection<ForeignKeyConstraint> getForeignKeyConstraints() {
        return this.foreignKeyConstraints;
    }

    @Override
    public Collection<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public Collection<String> getIdentityColumns() throws SQLException {
        return this.identityColumns;
    }
}

