/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.cache.eager;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DatabaseProperties;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.cache.DatabaseMetaDataCache;
import net.sf.hajdbc.cache.eager.EagerDatabaseProperties;
import net.sf.hajdbc.dialect.Dialect;

public class SharedEagerDatabaseMetaDataCache<Z, D extends Database<Z>>
implements DatabaseMetaDataCache<Z, D> {
    private final DatabaseCluster<Z, D> cluster;
    private volatile DatabaseProperties properties;

    public SharedEagerDatabaseMetaDataCache(DatabaseCluster<Z, D> cluster) {
        this.cluster = cluster;
    }

    @Override
    public void flush() throws SQLException {
        D database = this.cluster.getBalancer().next();
        if (database == null) {
            throw new SQLException(Messages.NO_ACTIVE_DATABASES.getMessage(new Object[0]));
        }
        this.setDatabaseProperties(database.connect(database.createConnectionSource(), database.decodePassword(this.cluster.getDecoder())));
    }

    @Override
    public synchronized DatabaseProperties getDatabaseProperties(D database, Connection connection) throws SQLException {
        if (this.properties == null) {
            this.setDatabaseProperties(connection);
        }
        return this.properties;
    }

    private synchronized void setDatabaseProperties(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        Dialect dialect = this.cluster.getDialect();
        this.properties = new EagerDatabaseProperties(metaData, dialect);
    }
}

