/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.cache.lazy;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DatabaseProperties;
import net.sf.hajdbc.cache.DatabaseMetaDataCache;
import net.sf.hajdbc.cache.lazy.LazyDatabaseMetaDataProvider;
import net.sf.hajdbc.cache.lazy.LazyDatabaseProperties;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.util.ref.ReferenceMap;
import net.sf.hajdbc.util.ref.SoftReferenceFactory;

public class LazyDatabaseMetaDataCache<Z, D extends Database<Z>>
implements DatabaseMetaDataCache<Z, D> {
    private final Map<D, Map.Entry<DatabaseProperties, LazyDatabaseMetaDataProvider>> map = new ReferenceMap<D, Map.Entry<DatabaseProperties, LazyDatabaseMetaDataProvider>>(new TreeMap(), SoftReferenceFactory.getInstance());
    private final DatabaseCluster<Z, D> cluster;

    public LazyDatabaseMetaDataCache(DatabaseCluster<Z, D> cluster) {
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws SQLException {
        Map<D, Map.Entry<DatabaseProperties, LazyDatabaseMetaDataProvider>> map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseProperties getDatabaseProperties(D database, Connection connection) throws SQLException {
        Map<D, Map.Entry<DatabaseProperties, LazyDatabaseMetaDataProvider>> map = this.map;
        synchronized (map) {
            Map.Entry<DatabaseProperties, LazyDatabaseMetaDataProvider> entry = this.map.get(database);
            if (entry == null) {
                DatabaseMetaData metaData = connection.getMetaData();
                Dialect dialect = this.cluster.getDialect();
                LazyDatabaseMetaDataProvider provider = new LazyDatabaseMetaDataProvider(metaData);
                LazyDatabaseProperties properties = new LazyDatabaseProperties(provider, dialect);
                entry = new AbstractMap.SimpleImmutableEntry<LazyDatabaseProperties, LazyDatabaseMetaDataProvider>(properties, provider);
                this.map.put(database, entry);
            } else {
                entry.getValue().setConnection(connection);
            }
            return entry.getKey();
        }
    }
}

