/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.cache.lazy;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.hajdbc.ColumnProperties;
import net.sf.hajdbc.ColumnPropertiesFactory;
import net.sf.hajdbc.ForeignKeyConstraint;
import net.sf.hajdbc.ForeignKeyConstraintFactory;
import net.sf.hajdbc.IdentifierNormalizer;
import net.sf.hajdbc.QualifiedName;
import net.sf.hajdbc.QualifiedNameFactory;
import net.sf.hajdbc.UniqueConstraint;
import net.sf.hajdbc.UniqueConstraintFactory;
import net.sf.hajdbc.cache.AbstractTableProperties;
import net.sf.hajdbc.cache.DatabaseMetaDataProvider;
import net.sf.hajdbc.dialect.Dialect;

public class LazyTableProperties
extends AbstractTableProperties {
    private final DatabaseMetaDataProvider metaDataProvider;
    private final Dialect dialect;
    private final UniqueConstraintFactory uniqueConstraintFactory;
    private final ForeignKeyConstraintFactory foreignKeyConstraintFactory;
    private final ColumnPropertiesFactory columnPropertiesFactory;
    private final AtomicReference<Map<String, ColumnProperties>> columnsRef = new AtomicReference();
    private final AtomicReference<UniqueConstraint> primaryKeyRef = new AtomicReference();
    private final AtomicReference<Collection<UniqueConstraint>> uniqueConstraintsRef = new AtomicReference();
    private final AtomicReference<Collection<ForeignKeyConstraint>> foreignKeyConstraintsRef = new AtomicReference();
    private final AtomicReference<Collection<String>> identityColumnsRef = new AtomicReference();

    public LazyTableProperties(QualifiedName table, DatabaseMetaDataProvider metaDataProvider, Dialect dialect, QualifiedNameFactory nameFactory) {
        super(table);
        this.metaDataProvider = metaDataProvider;
        this.dialect = dialect;
        IdentifierNormalizer normalizer = nameFactory.getIdentifierNormalizer();
        this.uniqueConstraintFactory = dialect.createUniqueConstraintFactory(normalizer);
        this.foreignKeyConstraintFactory = dialect.createForeignKeyConstraintFactory(nameFactory);
        this.columnPropertiesFactory = dialect.createColumnPropertiesFactory(normalizer);
    }

    @Override
    protected Map<String, ColumnProperties> getColumnMap() throws SQLException {
        Map<String, ColumnProperties> columns = this.columnsRef.get();
        if (columns == null && !this.columnsRef.compareAndSet(null, columns = this.dialect.getColumns(this.metaDataProvider.getDatabaseMetaData(), (QualifiedName)this.getName(), this.columnPropertiesFactory))) {
            return this.columnsRef.get();
        }
        return columns;
    }

    @Override
    public UniqueConstraint getPrimaryKey() throws SQLException {
        UniqueConstraint primaryKey = this.primaryKeyRef.get();
        if (primaryKey == null && !this.primaryKeyRef.compareAndSet(null, primaryKey = this.dialect.getPrimaryKey(this.metaDataProvider.getDatabaseMetaData(), (QualifiedName)this.getName(), this.uniqueConstraintFactory))) {
            return this.primaryKeyRef.get();
        }
        return primaryKey;
    }

    @Override
    public Collection<ForeignKeyConstraint> getForeignKeyConstraints() throws SQLException {
        Collection<ForeignKeyConstraint> foreignKeyConstraints = this.foreignKeyConstraintsRef.get();
        if (foreignKeyConstraints == null && !this.foreignKeyConstraintsRef.compareAndSet(null, foreignKeyConstraints = this.dialect.getForeignKeyConstraints(this.metaDataProvider.getDatabaseMetaData(), (QualifiedName)this.getName(), this.foreignKeyConstraintFactory))) {
            return this.foreignKeyConstraintsRef.get();
        }
        return foreignKeyConstraints;
    }

    @Override
    public Collection<UniqueConstraint> getUniqueConstraints() throws SQLException {
        Collection<UniqueConstraint> uniqueConstraints = this.uniqueConstraintsRef.get();
        if (uniqueConstraints == null && !this.uniqueConstraintsRef.compareAndSet(null, uniqueConstraints = this.dialect.getUniqueConstraints(this.metaDataProvider.getDatabaseMetaData(), (QualifiedName)this.getName(), this.getPrimaryKey(), this.uniqueConstraintFactory))) {
            return this.uniqueConstraintsRef.get();
        }
        return uniqueConstraints;
    }

    @Override
    public Collection<String> getIdentityColumns() throws SQLException {
        Collection<String> identityColumns = this.identityColumnsRef.get();
        if (identityColumns == null && !this.identityColumnsRef.compareAndSet(null, identityColumns = this.dialect.getIdentityColumns(this.getColumnMap().values()))) {
            return this.identityColumnsRef.get();
        }
        return identityColumns;
    }
}

