/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.cache.lazy;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Map;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DatabaseProperties;
import net.sf.hajdbc.cache.DatabaseMetaDataCache;
import net.sf.hajdbc.cache.lazy.LazyDatabaseMetaDataProvider;
import net.sf.hajdbc.cache.lazy.LazyDatabaseProperties;
import net.sf.hajdbc.dialect.Dialect;

public class SharedLazyDatabaseMetaDataCache<Z, D extends Database<Z>>
implements DatabaseMetaDataCache<Z, D> {
    private final DatabaseCluster<Z, D> cluster;
    private volatile Reference<Map.Entry<DatabaseProperties, LazyDatabaseMetaDataProvider>> entryRef = new SoftReference<Object>(null);

    public SharedLazyDatabaseMetaDataCache(DatabaseCluster<Z, D> cluster) {
        this.cluster = cluster;
    }

    @Override
    public synchronized void flush() {
        this.entryRef.clear();
    }

    @Override
    public DatabaseProperties getDatabaseProperties(D database, Connection connection) throws SQLException {
        Map.Entry<DatabaseProperties, LazyDatabaseMetaDataProvider> entry = this.entryRef.get();
        if (entry == null) {
            DatabaseMetaData metaData = connection.getMetaData();
            Dialect dialect = this.cluster.getDialect();
            LazyDatabaseMetaDataProvider provider = new LazyDatabaseMetaDataProvider(metaData);
            LazyDatabaseProperties properties = new LazyDatabaseProperties(provider, dialect);
            entry = new AbstractMap.SimpleImmutableEntry<LazyDatabaseProperties, LazyDatabaseMetaDataProvider>(properties, provider);
            this.entryRef = new SoftReference<Map.Entry<DatabaseProperties, LazyDatabaseMetaDataProvider>>(entry);
        } else {
            entry.getValue().setConnection(connection);
        }
        return entry.getKey();
    }
}

