/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.codec.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.sql.SQLException;
import javax.crypto.Cipher;
import net.sf.hajdbc.codec.Codec;
import org.apache.commons.codec.binary.Base64;

public class CipherCodec
implements Codec {
    private final Key key;

    public CipherCodec(Key key) {
        this.key = key;
    }

    public Key getKey() {
        return this.key;
    }

    @Override
    public String decode(String value) throws SQLException {
        try {
            Cipher cipher = Cipher.getInstance(this.key.getAlgorithm());
            cipher.init(2, this.key);
            return new String(cipher.doFinal(Base64.decodeBase64((byte[])value.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String encode(String value) throws SQLException {
        try {
            Cipher cipher = Cipher.getInstance(this.key.getAlgorithm());
            cipher.init(1, this.key);
            return new String(Base64.encodeBase64((byte[])cipher.doFinal(value.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new SQLException(e);
        }
    }
}

