/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.codec.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.sql.SQLException;
import java.text.MessageFormat;
import net.sf.hajdbc.codec.Codec;
import net.sf.hajdbc.codec.CodecFactory;
import net.sf.hajdbc.codec.crypto.CipherCodec;
import net.sf.hajdbc.util.Resources;
import net.sf.hajdbc.util.Strings;
import net.sf.hajdbc.util.SystemProperties;

public class CipherCodecFactory
implements CodecFactory,
Serializable {
    private static final long serialVersionUID = -4409167180573651279L;
    public static final String DEFAULT_KEYSTORE_FILE = String.format("%s/.keystore", SystemProperties.getSystemProperty("user.home"));
    public static final String DEFAULT_KEY_ALIAS = "ha-jdbc";

    private String getProperty(String id, Property property) {
        String value = SystemProperties.getSystemProperty(MessageFormat.format(property.nameFormat, id));
        if (value != null) {
            return value;
        }
        String pattern = SystemProperties.getSystemProperty(property.name, property.defaultValue);
        if (pattern == null) {
            return null;
        }
        return MessageFormat.format(pattern, id);
    }

    @Override
    public String getId() {
        return "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Codec createCodec(String clusterId) throws SQLException {
        String type = this.getProperty(clusterId, Property.KEYSTORE_TYPE);
        File file = new File(this.getProperty(clusterId, Property.KEYSTORE_FILE));
        String password = this.getProperty(clusterId, Property.KEYSTORE_PASSWORD);
        String keyAlias = this.getProperty(clusterId, Property.KEY_ALIAS);
        String keyPassword = this.getProperty(clusterId, Property.KEY_PASSWORD);
        try {
            KeyStore store = KeyStore.getInstance(type);
            FileInputStream input = new FileInputStream(file);
            try {
                store.load(input, password != null ? password.toCharArray() : null);
            }
            finally {
                Resources.close(input);
            }
            return new CipherCodec(store.getKey(keyAlias, keyPassword != null ? keyPassword.toCharArray() : null));
        }
        catch (GeneralSecurityException e) {
            throw new SQLException(e);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static void main(String ... args) {
        if (args.length != 2) {
            System.err.println(String.format("Usage:%s\tjava %s <cluster-id> <password-to-encrypt>", Strings.NEW_LINE, CipherCodecFactory.class.getName()));
            System.exit(1);
            return;
        }
        String clusterId = args[0];
        String value = args[1];
        try {
            Codec codec = new CipherCodecFactory().createCodec(clusterId);
            System.out.println(codec.encode(value));
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
    }

    static enum Property {
        KEYSTORE_FILE("keystore.file", DEFAULT_KEYSTORE_FILE),
        KEYSTORE_TYPE("keystore.type", "jceks"),
        KEYSTORE_PASSWORD("keystore.password", null),
        KEY_ALIAS("key.alias", "ha-jdbc"),
        KEY_PASSWORD("key.password", null);

        final String nameFormat;
        final String name;
        final String defaultValue;

        private Property(String name, String defaultValue) {
            this.nameFormat = "ha-jdbc.{0}." + name;
            this.name = "ha-jdbc." + name;
            this.defaultValue = defaultValue;
        }
    }
}

