/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.codec.hex;

import java.sql.SQLException;
import net.sf.hajdbc.codec.AbstractCodec;
import net.sf.hajdbc.codec.Codec;
import net.sf.hajdbc.util.Strings;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class HexCodecFactory
extends AbstractCodec {
    private static final long serialVersionUID = 5273729775503057299L;

    @Override
    public String getId() {
        return "16";
    }

    @Override
    public String decode(String value) throws SQLException {
        try {
            return new String(Hex.decodeHex((char[])value.toCharArray()));
        }
        catch (DecoderException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String encode(String value) {
        return new String(Hex.encodeHex((byte[])value.getBytes()));
    }

    public static void main(String ... args) {
        if (args.length != 2) {
            System.err.println(String.format("Usage:%s\tjava %s <cluster-id> <password-to-encrypt>", Strings.NEW_LINE, HexCodecFactory.class.getName()));
            System.exit(1);
            return;
        }
        String clusterId = args[0];
        String value = args[1];
        try {
            Codec codec = new HexCodecFactory().createCodec(clusterId);
            System.out.println(codec.encode(value));
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
    }
}

