/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect;

import java.util.Collection;
import java.util.LinkedList;
import net.sf.hajdbc.IdentifierNormalizer;

public class IdentifierList
extends LinkedList<String> {
    private static final long serialVersionUID = -3743137491103447812L;
    private final IdentifierNormalizer normalizer;

    public IdentifierList(IdentifierNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    @Override
    public boolean add(String id) {
        this.add(this.size(), id);
        return true;
    }

    @Override
    public void add(int index, String id) {
        super.add(index, this.normalizer.normalize(id));
    }

    @Override
    public void addFirst(String id) {
        this.add(0, id);
    }

    @Override
    public void addLast(String id) {
        this.add(id);
    }

    @Override
    public boolean addAll(Collection<? extends String> ids) {
        return this.addAll(this.size(), ids);
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> ids) {
        int i = index;
        for (String string : ids) {
            this.add(i++, string);
        }
        return i != index;
    }
}

