/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect;

import net.sf.hajdbc.AbstractNamed;
import net.sf.hajdbc.ColumnProperties;
import net.sf.hajdbc.ColumnPropertiesFactory;
import net.sf.hajdbc.IdentifierNormalizer;

public class StandardColumnPropertiesFactory
implements ColumnPropertiesFactory {
    private final IdentifierNormalizer normalizer;

    public StandardColumnPropertiesFactory(IdentifierNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    @Override
    public ColumnProperties createColumnProperties(String name, int type, String nativeType, String defaultValue, String remarks, Boolean autoIncrement) {
        return new StandardColumnProperties(this.normalizer.normalize(name), type, nativeType, autoIncrement);
    }

    private static class StandardColumnProperties
    extends AbstractNamed<String, ColumnProperties>
    implements ColumnProperties {
        private final int type;
        private final String nativeType;
        private final boolean autoIncrement;

        StandardColumnProperties(String name, int type, String nativeType, boolean autoIncrement) {
            super(name);
            this.type = type;
            this.nativeType = nativeType;
            this.autoIncrement = autoIncrement;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getNativeType() {
            return this.nativeType;
        }

        @Override
        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }
    }
}

