/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect;

import java.util.List;
import net.sf.hajdbc.ForeignKeyConstraint;
import net.sf.hajdbc.ForeignKeyConstraintFactory;
import net.sf.hajdbc.IdentifierNormalizer;
import net.sf.hajdbc.QualifiedName;
import net.sf.hajdbc.QualifiedNameFactory;
import net.sf.hajdbc.dialect.AbstractConstraint;
import net.sf.hajdbc.dialect.IdentifierList;

public class StandardForeignKeyConstraintFactory
implements ForeignKeyConstraintFactory {
    final QualifiedNameFactory factory;

    public StandardForeignKeyConstraintFactory(QualifiedNameFactory factory) {
        this.factory = factory;
    }

    @Override
    public QualifiedNameFactory getQualifiedNameFactory() {
        return this.factory;
    }

    @Override
    public ForeignKeyConstraint createForeignKeyConstraint(String name, QualifiedName table, QualifiedName foreignTable, int deleteRule, int updateRule, int deferrability) {
        IdentifierNormalizer normalizer = this.factory.getIdentifierNormalizer();
        return new StandardForeignKeyConstraint(normalizer.normalize(name), table, new IdentifierList(normalizer), foreignTable, new IdentifierList(normalizer), deleteRule, updateRule, deferrability);
    }

    private static class StandardForeignKeyConstraint
    extends AbstractConstraint<ForeignKeyConstraint>
    implements ForeignKeyConstraint {
        private final QualifiedName foreignTable;
        private final List<String> foreignColumns;
        private final int deleteRule;
        private final int updateRule;
        private final int deferrability;

        StandardForeignKeyConstraint(String name, QualifiedName table, List<String> columns, QualifiedName foreignTable, List<String> foreignColumns, int deleteRule, int updateRule, int deferrability) {
            super(name, table, columns);
            this.foreignTable = foreignTable;
            this.foreignColumns = foreignColumns;
            this.deleteRule = deleteRule;
            this.updateRule = updateRule;
            this.deferrability = deferrability;
        }

        @Override
        public QualifiedName getForeignTable() {
            return this.foreignTable;
        }

        @Override
        public List<String> getForeignColumnList() {
            return this.foreignColumns;
        }

        @Override
        public int getDeleteRule() {
            return this.deleteRule;
        }

        @Override
        public int getUpdateRule() {
            return this.updateRule;
        }

        @Override
        public int getDeferrability() {
            return this.deferrability;
        }
    }
}

