/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import net.sf.hajdbc.AbstractNamed;
import net.sf.hajdbc.IdentifierNormalizer;
import net.sf.hajdbc.QualifiedName;
import net.sf.hajdbc.QualifiedNameFactory;

public class StandardQualifiedNameFactory
implements QualifiedNameFactory {
    private final IdentifierNormalizer normalizer;
    private final boolean supportsSchemasInDDL;
    private final boolean supportsSchemasInDML;

    public StandardQualifiedNameFactory(DatabaseMetaData metaData, IdentifierNormalizer normalizer) throws SQLException {
        this.supportsSchemasInDML = metaData.supportsSchemasInDataManipulation();
        this.supportsSchemasInDDL = metaData.supportsSchemasInTableDefinitions();
        this.normalizer = normalizer;
    }

    @Override
    public QualifiedName createQualifiedName(String schema, String name) {
        return new StandardQualifiedName(this.normalizer.normalize(schema), this.normalizer.normalize(name), this.supportsSchemasInDDL, this.supportsSchemasInDML);
    }

    @Override
    public IdentifierNormalizer getIdentifierNormalizer() {
        return this.normalizer;
    }

    @Override
    public QualifiedName parse(String raw) {
        int index = raw.indexOf(".");
        String schema = index >= 0 ? raw.substring(0, index) : null;
        String name = index >= 0 ? raw.substring(index + 1) : raw;
        return this.createQualifiedName(schema, name);
    }

    private class StandardQualifiedName
    extends AbstractNamed<String, QualifiedName>
    implements QualifiedName {
        private final String schema;
        private final String ddlName;
        private final String dmlName;

        StandardQualifiedName(String schema, String name, boolean supportsSchemasInDDL, boolean supportsSchemasInDML) {
            super(name);
            this.schema = schema;
            this.ddlName = this.qualify(supportsSchemasInDDL);
            this.dmlName = supportsSchemasInDDL == supportsSchemasInDML ? this.ddlName : this.qualify(supportsSchemasInDML);
        }

        @Override
        public String getSchema() {
            return this.schema;
        }

        @Override
        public String getDDLName() {
            return this.ddlName;
        }

        @Override
        public String getDMLName() {
            return this.dmlName;
        }

        private String qualify(boolean supportsSchemas) {
            return supportsSchemas && this.schema != null ? this.schema + "." + (String)this.getName() : (String)this.getName();
        }
    }
}

