/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect.db2;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import net.sf.hajdbc.IdentityColumnSupport;
import net.sf.hajdbc.SequenceProperties;
import net.sf.hajdbc.SequencePropertiesFactory;
import net.sf.hajdbc.SequenceSupport;
import net.sf.hajdbc.dialect.StandardDialect;
import net.sf.hajdbc.util.Resources;

public class DB2Dialect
extends StandardDialect {
    @Override
    protected String vendorPattern() {
        return "db2";
    }

    @Override
    protected String executeFunctionFormat() {
        return "VALUES {0}";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SequenceProperties> getSequences(DatabaseMetaData metaData, SequencePropertiesFactory factory) throws SQLException {
        Statement statement = metaData.getConnection().createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT SEQSCHEMA, SEQNAME, INCREMENT FROM SYSCAT.SEQUENCES");
            LinkedList<SequenceProperties> sequences = new LinkedList<SequenceProperties>();
            while (resultSet.next()) {
                sequences.add(factory.createSequenceProperties(resultSet.getString(1), resultSet.getString(2), resultSet.getInt(3)));
            }
            LinkedList<SequenceProperties> linkedList = sequences;
            return linkedList;
        }
        finally {
            Resources.close(statement);
        }
    }

    @Override
    protected String sequencePattern() {
        return "(?:NEXT|PREV)VAL\\s+FOR\\s+'?([^',\\s\\(\\)]+)";
    }

    @Override
    protected String nextSequenceValueFormat() {
        return "NEXTVAL FOR {0}";
    }

    @Override
    protected String dateLiteralFormat() {
        return this.timestampLiteralFormat();
    }

    @Override
    protected String timeLiteralFormat() {
        return this.timestampLiteralFormat();
    }

    @Override
    protected String timestampLiteralFormat() {
        return "''{0}''";
    }
}

