/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect.derby;

import net.sf.hajdbc.IdentityColumnSupport;
import net.sf.hajdbc.SequenceSupport;
import net.sf.hajdbc.dialect.StandardDialect;

public class DerbyDialect
extends StandardDialect {
    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.meetsRequirement(10, 6) ? this : null;
    }

    @Override
    protected String vendorPattern() {
        return "derby";
    }

    @Override
    protected String executeFunctionFormat() {
        return "VALUES {0}";
    }

    @Override
    protected String createForeignKeyConstraintFormat() {
        return "ALTER TABLE {1} ADD CONSTRAINT {0} FOREIGN KEY ({2}) REFERENCES {3} ({4}) ON DELETE {5,choice,0#CASCADE|1#RESTRICT|2#SET NULL|3#NO ACTION|4#SET DEFAULT} ON UPDATE {6,choice,0#CASCADE|1#RESTRICT|2#SET NULL|3#NO ACTION|4#SET DEFAULT}";
    }

    @Override
    protected String currentDatePattern() {
        return super.currentDatePattern() + "|(?<=\\W)CURRENT\\s+DATE(?=\\W)";
    }

    @Override
    protected String currentTimePattern() {
        return super.currentTimePattern() + "|(?<=\\W)CURRENT\\s+TIME(?=\\W)";
    }

    @Override
    protected String currentTimestampPattern() {
        return super.currentTimestampPattern() + "|(?<=\\W)CURRENT\\s+TIMESTAMP(?=\\W)";
    }

    @Override
    protected String dateLiteralFormat() {
        return "DATE(''{0}'')";
    }

    @Override
    protected String timeLiteralFormat() {
        return "TIME(''{0}'')";
    }

    @Override
    protected String timestampLiteralFormat() {
        return "TIMESTAMP(''{0}'')";
    }
}

