/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect.firebird;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import net.sf.hajdbc.SequenceProperties;
import net.sf.hajdbc.SequencePropertiesFactory;
import net.sf.hajdbc.SequenceSupport;
import net.sf.hajdbc.dialect.StandardDialect;
import net.sf.hajdbc.util.Resources;

public class FirebirdDialect
extends StandardDialect {
    @Override
    protected String vendorPattern() {
        return "firebird";
    }

    @Override
    protected String dummyTable() {
        return "RDB$DATABASE";
    }

    @Override
    protected String alterSequenceFormat() {
        return "SET GENERATOR {0} TO {1}";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SequenceProperties> getSequences(DatabaseMetaData metaData, SequencePropertiesFactory factory) throws SQLException {
        Statement statement = metaData.getConnection().createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT RDB$GENERATOR_NAME FROM RDB$GENERATORS");
            LinkedList<SequenceProperties> sequences = new LinkedList<SequenceProperties>();
            while (resultSet.next()) {
                sequences.add(factory.createSequenceProperties(null, resultSet.getString(1), 1));
            }
            LinkedList<SequenceProperties> linkedList = sequences;
            return linkedList;
        }
        finally {
            Resources.close(statement);
        }
    }

    @Override
    protected String sequencePattern() {
        return "GEN_ID\\s*\\(\\s*([^\\s,]+)\\s*,\\s*\\d+\\s*\\)";
    }

    @Override
    protected String selectForUpdatePattern() {
        return "SELECT\\s+.+\\s+WITH\\s+LOCK";
    }

    @Override
    protected String nextSequenceValueFormat() {
        return "GEN_ID({0}, 1)";
    }
}

