/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect.ingres;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import net.sf.hajdbc.SequenceProperties;
import net.sf.hajdbc.SequencePropertiesFactory;
import net.sf.hajdbc.SequenceSupport;
import net.sf.hajdbc.dialect.StandardDialect;
import net.sf.hajdbc.util.Resources;

public class IngresDialect
extends StandardDialect {
    private final Pattern legacySequencePattern = Pattern.compile("'?(\\w+)'?\\.(?:(?:CURR)|(?:NEXT))VAL", 2);

    @Override
    protected String vendorPattern() {
        return "ingres";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SequenceProperties> getSequences(DatabaseMetaData metaData, SequencePropertiesFactory factory) throws SQLException {
        Statement statement = metaData.getConnection().createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT seq_name FROM iisequence");
            LinkedList<SequenceProperties> sequences = new LinkedList<SequenceProperties>();
            while (resultSet.next()) {
                sequences.add(factory.createSequenceProperties(null, resultSet.getString(1), 1));
            }
            LinkedList<SequenceProperties> linkedList = sequences;
            return linkedList;
        }
        finally {
            Resources.close(statement);
        }
    }

    @Override
    public String parseSequence(String sql) {
        String sequence = super.parseSequence(sql);
        return sequence != null ? sequence : this.parse(this.legacySequencePattern, sql);
    }

    @Override
    protected String sequencePattern() {
        return "(?:NEXT|CURRENT)\\s+VALUE\\s+FOR\\s+'?([^',\\s\\(\\)]+)";
    }

    @Override
    protected String currentDatePattern() {
        return "(?<=\\W)CURRENT_DATE(?=\\W)|(?<=\\W)DATE\\s*\\(\\s*'TODAY'\\s*\\)";
    }

    @Override
    protected String currentTimePattern() {
        return "(?<=\\W)CURRENT_TIME(?=\\W)|(?<=\\W)LOCAL_TIME(?=\\W)";
    }

    @Override
    protected String currentTimestampPattern() {
        return "(?<=\\W)CURRENT_TIMESTAMP(?=\\W)|(?<=\\W)LOCAL_TIMESTAMP(?=\\W)|(?<=\\W)DATE\\s*\\(\\s*'NOW'\\s*\\)";
    }

    @Override
    protected String randomPattern() {
        return "(?<=\\W)RANDOMF\\s*\\(\\s*\\)";
    }
}

