/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect.maxdb;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import net.sf.hajdbc.SequenceProperties;
import net.sf.hajdbc.SequencePropertiesFactory;
import net.sf.hajdbc.SequenceSupport;
import net.sf.hajdbc.dialect.StandardDialect;
import net.sf.hajdbc.util.Resources;

public class MaxDBDialect
extends StandardDialect {
    @Override
    protected String vendorPattern() {
        return "maxdb";
    }

    @Override
    protected String dummyTable() {
        return "DUAL";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SequenceProperties> getSequences(DatabaseMetaData metaData, SequencePropertiesFactory factory) throws SQLException {
        Statement statement = metaData.getConnection().createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT SEQUENCE_NAME, INCREMENT_BY FROM USER_SEQUENCES");
            LinkedList<SequenceProperties> sequences = new LinkedList<SequenceProperties>();
            while (resultSet.next()) {
                sequences.add(factory.createSequenceProperties(null, resultSet.getString(1), resultSet.getInt(2)));
            }
            LinkedList<SequenceProperties> linkedList = sequences;
            return linkedList;
        }
        finally {
            Resources.close(statement);
        }
    }

    @Override
    protected String truncateTableFormat() {
        return "TRUNCATE TABLE {0}";
    }

    @Override
    protected String createForeignKeyConstraintFormat() {
        return "ALTER TABLE {1} ADD CONSTRAINT {0} FOREIGN KEY ({2}) REFERENCES {3} ({4}) ON DELETE {5,choice,0#CASCADE|1#RESTRICT|2#SET NULL|3#NO ACTION|4#SET DEFAULT}";
    }

    @Override
    protected String sequencePattern() {
        return "'?(\\w+)'?\\.(?:CURR|NEXT)VAL";
    }

    @Override
    protected String nextSequenceValueFormat() {
        return "{0}.NEXTVAL";
    }
}

