/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect.mysql;

import java.io.File;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import net.sf.hajdbc.ConnectionProperties;
import net.sf.hajdbc.DumpRestoreSupport;
import net.sf.hajdbc.dialect.StandardDialect;
import net.sf.hajdbc.util.Strings;

public class MySQLDialect
extends StandardDialect
implements DumpRestoreSupport {
    private static final File PASSWORD_FILE = new File(String.format("%s%s.my.cnf", Strings.USER_HOME, Strings.FILE_SEPARATOR));

    @Override
    protected String vendorPattern() {
        return "mysql";
    }

    @Override
    public List<String> getDefaultSchemas(DatabaseMetaData metaData) throws SQLException {
        return Collections.singletonList(this.executeFunction(metaData.getConnection(), "DATABASE()"));
    }

    @Override
    protected String createForeignKeyConstraintFormat() {
        return "ALTER TABLE {1} ADD CONSTRAINT {0} FOREIGN KEY ({2}) REFERENCES {3} ({4}) ON DELETE {5,choice,0#CASCADE|1#RESTRICT|2#SET NULL|3#NO ACTION|4#SET DEFAULT} ON UPDATE {6,choice,0#CASCADE|1#RESTRICT|2#SET NULL|3#NO ACTION|4#SET DEFAULT}";
    }

    @Override
    protected String createUniqueConstraintFormat() {
        return "ALTER TABLE {1} ADD UNIQUE {0} ({2})";
    }

    @Override
    protected String dropForeignKeyConstraintFormat() {
        return "ALTER TABLE {1} DROP FOREIGN KEY {0}";
    }

    @Override
    protected String dropUniqueConstraintFormat() {
        return "ALTER TABLE {1} DROP INDEX {0}";
    }

    @Override
    protected String alterIdentityColumnFormat() {
        return "ALTER TABLE {0} AUTO_INCREMENT = {2}";
    }

    @Override
    protected String currentDatePattern() {
        return super.currentDatePattern() + "|(?<=\\W)CURDATE\\s*\\(\\s*\\)";
    }

    @Override
    protected String currentTimePattern() {
        return super.currentTimePattern() + "|(?<=\\W)CURTIME\\s*\\(\\s*\\)";
    }

    @Override
    protected String currentTimestampPattern() {
        return super.currentTimestampPattern() + "|(?<=\\W)NOW\\s*\\(\\s*\\)|(?<=\\W)SYSDATE\\s*\\(\\s*\\)";
    }

    @Override
    protected String dateLiteralFormat() {
        return this.timestampLiteralFormat();
    }

    @Override
    protected String timeLiteralFormat() {
        return this.timestampLiteralFormat();
    }

    @Override
    protected String timestampLiteralFormat() {
        return "''{0}''";
    }

    @Override
    public DumpRestoreSupport getDumpRestoreSupport() {
        return this;
    }

    @Override
    public ProcessBuilder createDumpProcess(ConnectionProperties properties, File file) {
        return this.setPassword(new ProcessBuilder("mysqldump", "-h", properties.getHost(), "-P", properties.getPort(), "-u", properties.getUser(), properties.getDatabase(), ">", file.getPath()), properties);
    }

    @Override
    public ProcessBuilder createRestoreProcess(ConnectionProperties properties, File file) {
        return this.setPassword(new ProcessBuilder("mysql", "-h", properties.getHost(), "-P", properties.getPort(), "-u", properties.getUser(), properties.getDatabase(), "<", file.getPath()), properties);
    }

    private ProcessBuilder setPassword(ProcessBuilder builder, ConnectionProperties properties) {
        if (!PASSWORD_FILE.exists()) {
            builder.environment().put("MYSQL_PWD", properties.getPassword());
        }
        return builder;
    }
}

