/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect.postgresql;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.hajdbc.ColumnProperties;
import net.sf.hajdbc.ConnectionProperties;
import net.sf.hajdbc.DumpRestoreSupport;
import net.sf.hajdbc.IdentifierNormalizer;
import net.sf.hajdbc.IdentityColumnSupport;
import net.sf.hajdbc.SequenceSupport;
import net.sf.hajdbc.TriggerSupport;
import net.sf.hajdbc.dialect.StandardDialect;
import net.sf.hajdbc.dialect.StandardIdentifierNormalizer;
import net.sf.hajdbc.util.Resources;
import net.sf.hajdbc.util.Strings;

public class PostgreSQLDialect
extends StandardDialect
implements DumpRestoreSupport {
    private static final File PASSWORD_FILE = new File(String.format("%s%s.pgpass", Strings.USER_HOME, Strings.FILE_SEPARATOR));

    @Override
    protected String vendorPattern() {
        return "postgresql";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDefaultSchemas(DatabaseMetaData metaData) throws SQLException {
        Connection connection = metaData.getConnection();
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SHOW search_path");
            resultSet.next();
            String[] schemas = resultSet.getString(1).split(",");
            ArrayList<String> schemaList = new ArrayList<String>(schemas.length);
            for (String schema : schemas) {
                schemaList.add(schema.equals("$user") ? metaData.getUserName() : schema);
            }
            ArrayList<String> arrayList = schemaList;
            return arrayList;
        }
        finally {
            Resources.close(statement);
        }
    }

    @Override
    public int getColumnType(ColumnProperties properties) {
        return properties.getNativeType().equalsIgnoreCase("oid") ? 2004 : properties.getType();
    }

    @Override
    public IdentifierNormalizer createIdentifierNormalizer(DatabaseMetaData metaData) throws SQLException {
        if (metaData.getDriverMajorVersion() >= 8 && metaData.getDriverMinorVersion() >= 1) {
            return new StandardIdentifierNormalizer(metaData, Pattern.compile("[A-Za-z\\0200-\\0377_][A-Za-z\\0200-\\0377_0-9\\$]*"));
        }
        return super.createIdentifierNormalizer(metaData);
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this;
    }

    @Override
    protected String truncateTableFormat() {
        return "TRUNCATE TABLE {0}";
    }

    @Override
    protected String sequencePattern() {
        return "(?:CURR|NEXT)VAL\\s*\\(\\s*'([^']+)'\\s*\\)";
    }

    @Override
    protected String nextSequenceValueFormat() {
        return "NEXTVAL(''{0}'')";
    }

    @Override
    protected String alterIdentityColumnFormat() {
        return "ALTER SEQUENCE {0}_{1}_seq RESTART WITH {2}";
    }

    @Override
    protected String currentTimestampPattern() {
        return super.currentTimestampPattern() + "|(?<=\\W)NOW\\s*\\(\\s*\\)|(?<=\\W)TRANSACTION_TIMESTAMP\\s*\\(\\s*\\)|(?<=\\W)STATEMENT_TIMESTAMP\\s*\\(\\s*\\)|(?<=\\W)CLOCK_TIMESTAMP\\s*\\(\\s*\\)";
    }

    @Override
    protected String randomPattern() {
        return "(?<=\\W)RANDOM\\s*\\(\\s*\\)";
    }

    @Override
    protected String selectForUpdatePattern() {
        return "SELECT\\s+.+\\s+FOR\\s+(SHARE|UPDATE)";
    }

    @Override
    public DumpRestoreSupport getDumpRestoreSupport() {
        return this;
    }

    @Override
    public ProcessBuilder createDumpProcess(ConnectionProperties properties, File file) {
        return this.setPassword(new ProcessBuilder("pg_dump", "-h", properties.getHost(), "-p", properties.getPort(), "-U", properties.getUser(), "-f", file.getPath(), "-F", "tar", properties.getDatabase()), properties);
    }

    @Override
    public ProcessBuilder createRestoreProcess(ConnectionProperties properties, File file) {
        return this.setPassword(new ProcessBuilder("pg_restore", "-h", properties.getHost(), "-p", properties.getPort(), "-U", properties.getUser(), "-d", properties.getDatabase(), file.getPath()), properties);
    }

    private ProcessBuilder setPassword(ProcessBuilder builder, ConnectionProperties properties) {
        if (!PASSWORD_FILE.exists()) {
            builder.environment().put("PGPASSWORD", properties.getPassword());
        }
        return builder;
    }

    @Override
    public TriggerSupport getTriggerSupport() {
        return this;
    }

    @Override
    protected String createTriggerFormat() {
        return "CREATE FUNCTION {0}_action() BEGIN {4} END; CREATE TRIGGER {0} {1} {2} ON {3} FOR EACH ROW EXECUTE PROCEDURE {0}_action()";
    }

    @Override
    protected String dropTriggerFormat() {
        return "DROP TRIGGER {0} ON {1}; DROP FUNCTION {0}_action()";
    }
}

