/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.dialect.sybase;

import net.sf.hajdbc.IdentityColumnSupport;
import net.sf.hajdbc.dialect.StandardDialect;

public class SybaseDialect
extends StandardDialect {
    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this;
    }

    @Override
    protected String vendorPattern() {
        return "sybase";
    }

    @Override
    protected String truncateTableFormat() {
        return "TRUNCATE TABLE {0}";
    }

    @Override
    protected String createForeignKeyConstraintFormat() {
        return "ALTER TABLE {1} ADD CONSTRAINT {0} FOREIGN KEY ({2}) REFERENCES {3} ({4}) ON DELETE {5,choice,0#CASCADE|1#RESTRICT|2#SET NULL|3#NO ACTION|4#SET DEFAULT} ON UPDATE {6,choice,0#CASCADE|1#RESTRICT|2#SET NULL|3#NO ACTION|4#SET DEFAULT}";
    }

    @Override
    protected String currentDatePattern() {
        return "(?<=\\W)CURRENT\\s+DATE(?=\\W)|(?<=\\W)TODAY\\s*\\(\\s*\\*\\s*\\)";
    }

    @Override
    protected String currentTimePattern() {
        return "(?<=\\W)CURRENT\\s+TIME(?=\\W)";
    }

    @Override
    protected String currentTimestampPattern() {
        return "(?<=\\W)CURRENT\\s+TIMESTAMP(?=\\W)|(?<=\\W)GETDATE\\s*\\(\\s*\\)|(?<=\\W)NOW\\s*\\(\\s*\\*\\s*\\)";
    }

    @Override
    protected String dateLiteralFormat() {
        return this.timestampLiteralFormat();
    }

    @Override
    protected String timeLiteralFormat() {
        return this.timestampLiteralFormat();
    }

    @Override
    protected String timestampLiteralFormat() {
        return "''{0}''";
    }

    @Override
    protected String randomPattern() {
        return "(?<=\\W)RAND\\s*\\(\\s*\\d*\\s*\\)";
    }
}

