/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.distributed.jgroups;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.distributed.Command;
import net.sf.hajdbc.distributed.CommandDispatcher;
import net.sf.hajdbc.distributed.Member;
import net.sf.hajdbc.distributed.MembershipListener;
import net.sf.hajdbc.distributed.Stateful;
import net.sf.hajdbc.distributed.jgroups.AddressMember;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.util.Objects;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class JGroupsCommandDispatcher<C>
implements RequestHandler,
CommandDispatcher<C>,
org.jgroups.MembershipListener,
MessageListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String id;
    private final long timeout;
    private final MessageDispatcher dispatcher;
    private final C context;
    private final AtomicReference<View> viewReference = new AtomicReference();
    private final MembershipListener membershipListener;
    private final Stateful stateful;

    public JGroupsCommandDispatcher(String id, Channel channel, long timeout, C context, Stateful stateful, MembershipListener membershipListener) throws Exception {
        this.id = id;
        this.context = context;
        this.stateful = stateful;
        this.membershipListener = membershipListener;
        this.dispatcher = new MessageDispatcher(channel, (MessageListener)this, (org.jgroups.MembershipListener)this, (RequestHandler)this);
        this.timeout = timeout;
    }

    @Override
    public void start() throws Exception {
        Channel channel = this.dispatcher.getChannel();
        channel.setDiscardOwnMessages(true);
        channel.connect(this.id, null, 0L);
    }

    @Override
    public void stop() {
        Channel channel = this.dispatcher.getChannel();
        if (channel.isOpen()) {
            if (channel.isConnected()) {
                channel.disconnect();
            }
            channel.close();
        }
    }

    @Override
    public <R> Map<Member, R> executeAll(Command<R, C> command) {
        Message message = new Message(null, this.getLocalAddress(), Objects.serialize(command));
        try {
            RspList responses = this.dispatcher.castMessage(null, message, new RequestOptions(ResponseMode.GET_ALL, this.timeout));
            if (responses == null) {
                return Collections.emptyMap();
            }
            TreeMap<AddressMember, Object> results = new TreeMap<AddressMember, Object>();
            for (Map.Entry entry : responses.entrySet()) {
                Rsp response = (Rsp)entry.getValue();
                results.put(new AddressMember((Address)entry.getKey()), response.wasReceived() ? response.getValue() : null);
            }
            return results;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <R> R executeCoordinator(Command<R, C> command) {
        Message message = new Message(this.getCoordinatorAddress(), this.getLocalAddress(), Objects.serialize(command));
        try {
            return (R)this.dispatcher.sendMessage(message, new RequestOptions(ResponseMode.GET_ALL, this.timeout));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isCoordinator() {
        return this.getLocalAddress().equals(this.getCoordinatorAddress());
    }

    @Override
    public Member getLocal() {
        return new AddressMember(this.getLocalAddress());
    }

    private Address getLocalAddress() {
        return this.dispatcher.getChannel().getAddress();
    }

    @Override
    public Member getCoordinator() {
        return new AddressMember(this.getCoordinatorAddress());
    }

    private Address getCoordinatorAddress() {
        return (Address)this.dispatcher.getChannel().getView().getMembers().get(0);
    }

    public Object handle(Message message) {
        Command command = (Command)Objects.deserialize(message.getRawBuffer());
        this.logger.log(Level.DEBUG, Messages.COMMAND_RECEIVED.getMessage(command, message.getSrc()), new Object[0]);
        return command.execute(this.context);
    }

    public void viewAccepted(View view) {
        if (this.membershipListener != null) {
            View oldView = this.viewReference.getAndSet(view);
            for (Address address : view.getMembers()) {
                if (oldView != null && oldView.containsMember(address)) continue;
                this.membershipListener.added(new AddressMember(address));
            }
            if (oldView != null) {
                for (Address address : oldView.getMembers()) {
                    if (view.containsMember(address)) continue;
                    this.membershipListener.removed(new AddressMember(address));
                }
            }
        }
    }

    public void getState(OutputStream output) throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(output);
        this.stateful.writeState(out);
        out.flush();
    }

    public void setState(InputStream input) throws Exception {
        this.stateful.readState(new ObjectInputStream(input));
    }

    public void suspect(Address member) {
    }

    public void block() {
    }

    public void unblock() {
    }

    public void receive(Message message) {
    }
}

