/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.durability.coarse;

import java.util.Map;
import java.util.SortedMap;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.durability.Durability;
import net.sf.hajdbc.durability.InvocationEvent;
import net.sf.hajdbc.durability.InvocationEventImpl;
import net.sf.hajdbc.durability.InvokerEvent;
import net.sf.hajdbc.durability.none.NoDurability;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.state.StateManager;

public class CoarseDurability<Z, D extends Database<Z>>
extends NoDurability<Z, D> {
    protected final DatabaseCluster<Z, D> cluster;

    public CoarseDurability(DatabaseCluster<Z, D> cluster) {
        this.cluster = cluster;
    }

    @Override
    public InvocationStrategy getInvocationStrategy(final InvocationStrategy strategy, final Durability.Phase phase, final Object transactionId) {
        final StateManager listener = this.cluster.getStateManager();
        return new InvocationStrategy(){

            public <ZZ, DD extends Database<ZZ>, T, R, EE extends Exception> SortedMap<DD, R> invoke(SQLProxy<ZZ, DD, T, EE> proxy, Invoker<ZZ, DD, T, R, EE> invoker) throws EE {
                InvocationEventImpl event = new InvocationEventImpl(transactionId, phase, proxy.getExceptionFactory().getType());
                listener.beforeInvocation(event);
                try {
                    SortedMap<DD, R> sortedMap = strategy.invoke(proxy, invoker);
                    return sortedMap;
                }
                catch (Exception e) {
                    throw proxy.getExceptionFactory().createException(e);
                }
                finally {
                    listener.afterInvocation(event);
                }
            }
        };
    }

    @Override
    public void recover(Map<InvocationEvent, Map<String, InvokerEvent>> invokers) {
        StateManager stateManager = this.cluster.getStateManager();
        for (Database database : this.cluster.getBalancer().backups()) {
            this.cluster.deactivate(database, stateManager);
        }
        for (InvocationEvent event : invokers.keySet()) {
            stateManager.afterInvocation(event);
        }
    }
}

