/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.durability.fine;

import java.util.Map;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionFactory;
import net.sf.hajdbc.balancer.Balancer;
import net.sf.hajdbc.durability.Durability;
import net.sf.hajdbc.durability.InvocationEvent;
import net.sf.hajdbc.durability.InvokerEvent;
import net.sf.hajdbc.durability.InvokerEventImpl;
import net.sf.hajdbc.durability.InvokerResult;
import net.sf.hajdbc.durability.InvokerResultImpl;
import net.sf.hajdbc.durability.coarse.CoarseDurability;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.state.StateManager;
import net.sf.hajdbc.util.Objects;

public class FineDurability<Z, D extends Database<Z>>
extends CoarseDurability<Z, D> {
    public FineDurability(DatabaseCluster<Z, D> cluster) {
        super(cluster);
    }

    @Override
    public <T, R, E extends Exception> Invoker<Z, D, T, R, E> getInvoker(final Invoker<Z, D, T, R, E> invoker, final Durability.Phase phase, final Object transactionId, final ExceptionFactory<E> exceptionFactory) {
        final StateManager listener = this.cluster.getStateManager();
        return new Invoker<Z, D, T, R, E>(){

            @Override
            public R invoke(D database, T object) throws Exception {
                InvokerEventImpl event = new InvokerEventImpl(transactionId, phase, database.getId());
                listener.beforeInvoker(event);
                try {
                    Object result = invoker.invoke(database, object);
                    event.setResult(new InvokerResultImpl(result));
                    Object r = result;
                    return r;
                }
                catch (Exception e) {
                    event.setResult(new InvokerResultImpl(e));
                    throw exceptionFactory.createException(e);
                }
                finally {
                    listener.afterInvoker(event);
                }
            }
        };
    }

    @Override
    public void recover(Map<InvocationEvent, Map<String, InvokerEvent>> map) {
        StateManager stateManager = this.cluster.getStateManager();
        Balancer balancer = this.cluster.getBalancer();
        Object primary = balancer.primary();
        for (Map.Entry<InvocationEvent, Map<String, InvokerEvent>> entry : map.entrySet()) {
            InvocationEvent invocation = entry.getKey();
            Map<String, InvokerEvent> invokers = entry.getValue();
            if (!invokers.isEmpty()) {
                for (Database backup : balancer.backups()) {
                    if (!this.deactivateSlave(primary, backup, invocation, invokers)) continue;
                    this.cluster.deactivate(backup, stateManager);
                }
            }
            stateManager.afterInvocation(invocation);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deactivateSlave(D primary, D backup, InvocationEvent invocation, Map<String, InvokerEvent> invokers) {
        InvokerEvent primaryEvent = invokers.get(primary.getId());
        if (primaryEvent != null) {
            InvokerResult result = primaryEvent.getResult();
            if (result == null) return true;
            Object primaryValue = result.getValue();
            Exception primaryException = result.getException();
            InvokerEvent backupEvent = invokers.get(backup.getId());
            if (backupEvent == null) return true;
            InvokerResult backupResult = backupEvent.getResult();
            if (backupResult == null) return true;
            Object backupValue = backupResult.getValue();
            Exception backupException = backupResult.getException();
            if (!(primaryException != null ? backupException == null || !invocation.getExceptionType().getExceptionFactory().equals(primaryException, backupException) : backupException != null || !Objects.equals(primaryValue, backupValue))) return false;
            return true;
        }
        if (!invokers.containsKey(backup.getId())) return false;
        return true;
    }
}

