/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.invocation;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionFactory;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.balancer.Balancer;
import net.sf.hajdbc.invocation.InvokeOnManyInvocationStrategy;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.SQLProxy;

public class InvokeOnAllInvocationStrategy
extends InvokeOnManyInvocationStrategy {
    @Override
    protected <Z, D extends Database<Z>, T, R, E extends Exception> Map.Entry<SortedMap<D, R>, SortedMap<D, E>> collectResults(SQLProxy<Z, D, T, E> proxy, Invoker<Z, D, T, R, E> invoker) {
        DatabaseCluster<Z, D> cluster = proxy.getDatabaseCluster();
        Balancer<Z, D> databaseSet = cluster.getBalancer();
        proxy.getRoot().retain(databaseSet);
        ExceptionFactory<E> exceptionFactory = proxy.getExceptionFactory();
        if (databaseSet.isEmpty()) {
            exceptionFactory.createException(Messages.NO_ACTIVE_DATABASES.getMessage(cluster));
        }
        int size = databaseSet.size();
        ArrayList<Invocation<Z, Database, T, R, E>> invocationList = new ArrayList<Invocation<Z, Database, T, R, E>>(size);
        for (Database database : databaseSet) {
            invocationList.add(new Invocation<Z, Database, T, R, E>(invoker, database, proxy.getObject(database)));
        }
        try {
            List futureList = this.getExecutor(cluster).invokeAll(invocationList);
            TreeMap resultMap = new TreeMap();
            TreeMap exceptionMap = new TreeMap();
            for (int i = 0; i < invocationList.size(); ++i) {
                Object database = ((Invocation)invocationList.get(i)).getDatabase();
                try {
                    resultMap.put(database, futureList.get(i).get());
                    continue;
                }
                catch (ExecutionException e) {
                    exceptionMap.put(database, exceptionFactory.createException(e.getCause()));
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    exceptionMap.put(database, exceptionFactory.createException(e));
                }
            }
            return new AbstractMap.SimpleImmutableEntry<SortedMap<D, R>, SortedMap<D, E>>(resultMap, exceptionMap);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected <Z, D extends Database<Z>> ExecutorService getExecutor(DatabaseCluster<Z, D> cluster) {
        return cluster.getExecutor();
    }

    private static class Invocation<Z, D extends Database<Z>, T, R, E extends Exception>
    implements Callable<R> {
        private final Invoker<Z, D, T, R, E> invoker;
        private final D database;
        private final T object;

        Invocation(Invoker<Z, D, T, R, E> invoker, D database, T object) {
            this.invoker = invoker;
            this.database = database;
            this.object = object;
        }

        D getDatabase() {
            return this.database;
        }

        @Override
        public R call() throws E {
            return this.invoker.invoke(this.database, this.object);
        }
    }
}

