/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.invocation;

import java.util.Map;
import java.util.SortedMap;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionFactory;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.invocation.InvokeOnExistingInvocationStrategy;
import net.sf.hajdbc.invocation.InvokeOnNextInvocationStrategy;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.state.StateManager;
import net.sf.hajdbc.util.Collections;

public class InvokeOnAnyInvocationStrategy
extends InvokeOnNextInvocationStrategy {
    private static Logger logger = LoggerFactory.getLogger(InvokeOnExistingInvocationStrategy.class);

    @Override
    public <Z, D extends Database<Z>, T, R, E extends Exception> SortedMap<D, R> invoke(SQLProxy<Z, D, T, E> proxy, Invoker<Z, D, T, R, E> invoker) throws E {
        DatabaseCluster<Z, Database> cluster = proxy.getDatabaseCluster();
        Dialect dialect = cluster.getDialect();
        StateManager stateManager = cluster.getStateManager();
        ExceptionFactory<E> exceptionFactory = proxy.getExceptionFactory();
        for (Map.Entry<D, T> entry : proxy.entries()) {
            Database database = (Database)entry.getKey();
            try {
                R result = invoker.invoke(database, entry.getValue());
                return Collections.singletonSortedMap(database, result);
            }
            catch (Exception e) {
                E exception = exceptionFactory.createException(e);
                if (exceptionFactory.indicatesFailure(exception, dialect) && cluster.getBalancer().size() > 1) {
                    if (!cluster.deactivate(database, stateManager)) continue;
                    logger.log(Level.ERROR, (Throwable)exception, Messages.DATABASE_DEACTIVATED.getMessage(new Object[0]), database, cluster);
                    continue;
                }
                throw exception;
            }
        }
        return super.invoke(proxy, invoker);
    }
}

