/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.invocation;

import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionFactory;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.state.StateManager;

public abstract class InvokeOnManyInvocationStrategy
implements InvocationStrategy {
    private static Logger logger = LoggerFactory.getLogger(InvokeOnManyInvocationStrategy.class);

    @Override
    public <Z, D extends Database<Z>, T, R, E extends Exception> SortedMap<D, R> invoke(SQLProxy<Z, D, T, E> proxy, Invoker<Z, D, T, R, E> invoker) throws E {
        Map.Entry<SortedMap<D, R>, SortedMap<D, E>> results = this.collectResults(proxy, invoker);
        SortedMap<D, R> resultMap = results.getKey();
        SortedMap<D, E> exceptionMap = results.getValue();
        if (!exceptionMap.isEmpty()) {
            ExceptionFactory<Exception> exceptionFactory = proxy.getExceptionFactory();
            DatabaseCluster<Z, Database> cluster = proxy.getDatabaseCluster();
            Dialect dialect = cluster.getDialect();
            ArrayList<D> failedDatabases = new ArrayList<D>(exceptionMap.size());
            for (Map.Entry<D, E> entry : exceptionMap.entrySet()) {
                if (!exceptionFactory.indicatesFailure((Exception)entry.getValue(), dialect)) continue;
                failedDatabases.add(entry.getKey());
            }
            StateManager stateManager = cluster.getStateManager();
            if (!resultMap.isEmpty() || failedDatabases.size() < exceptionMap.size()) {
                for (Database database : failedDatabases) {
                    Exception exception = (Exception)exceptionMap.remove(database);
                    if (!cluster.deactivate(database, stateManager)) continue;
                    logger.log(Level.ERROR, exception, Messages.DATABASE_DEACTIVATED.getMessage(new Object[0]), database, cluster);
                }
            }
            if (!(exceptionMap.isEmpty() || !resultMap.isEmpty() && exceptionMap.headMap(resultMap.firstKey()).isEmpty())) {
                Database primaryDatabase = (Database)exceptionMap.firstKey();
                Exception exception = (Exception)exceptionMap.get(primaryDatabase);
                for (Map.Entry<Database, E> entry : exceptionMap.tailMap(primaryDatabase).entrySet()) {
                    Database database;
                    Exception exception2 = (Exception)entry.getValue();
                    if (exceptionFactory.equals(exception2, exception) || !cluster.deactivate(database = entry.getKey(), stateManager)) continue;
                    logger.log(Level.ERROR, exception2, Messages.DATABASE_INCONSISTENT.getMessage(new Object[0]), database, cluster, exception, exception2);
                }
                for (Map.Entry<Database<Object>, Object> entry : resultMap.entrySet()) {
                    Database<Object> database = entry.getKey();
                    if (!cluster.deactivate(database, stateManager)) continue;
                    logger.log(Level.ERROR, Messages.DATABASE_INCONSISTENT.getMessage(new Object[0]), database, cluster, exception, entry.getValue());
                }
                throw exception;
            }
            for (Map.Entry entry : exceptionMap.entrySet()) {
                Database database = (Database)entry.getKey();
                Exception exception = (Exception)entry.getValue();
                if (!cluster.deactivate(database, stateManager)) continue;
                logger.log(Level.ERROR, exception, Messages.DATABASE_DEACTIVATED.getMessage(new Object[0]), database, cluster);
            }
        }
        return resultMap;
    }

    protected abstract <Z, D extends Database<Z>, T, R, E extends Exception> Map.Entry<SortedMap<D, R>, SortedMap<D, E>> collectResults(SQLProxy<Z, D, T, E> var1, Invoker<Z, D, T, R, E> var2);
}

