/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.invocation;

import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionFactory;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.balancer.Balancer;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.state.StateManager;

public abstract class InvokeOnOneInvocationStrategy
implements InvocationStrategy {
    private static Logger logger = LoggerFactory.getLogger(InvokeOnOneInvocationStrategy.class);

    @Override
    public <Z, D extends Database<Z>, T, R, E extends Exception> SortedMap<D, R> invoke(SQLProxy<Z, D, T, E> proxy, Invoker<Z, D, T, R, E> invoker) throws E {
        TreeMap<D, R> resultMap = new TreeMap<D, R>();
        DatabaseCluster<Z, D> cluster = proxy.getDatabaseCluster();
        Balancer<Z, D> balancer = cluster.getBalancer();
        Dialect dialect = cluster.getDialect();
        StateManager stateManager = cluster.getStateManager();
        ExceptionFactory<E> exceptionFactory = proxy.getExceptionFactory();
        while (true) {
            D database;
            if ((database = this.getTarget(balancer)) == null) {
                throw exceptionFactory.createException(Messages.NO_ACTIVE_DATABASES.getMessage(cluster));
            }
            T object = proxy.getObject(database);
            try {
                R result = balancer.invoke(invoker, database, object);
                resultMap.put(database, result);
                return resultMap;
            }
            catch (Exception e) {
                E exception = exceptionFactory.createException(e);
                if (exceptionFactory.indicatesFailure(exception, dialect)) {
                    if (!cluster.deactivate(database, stateManager)) continue;
                    logger.log(Level.ERROR, (Throwable)exception, Messages.DATABASE_DEACTIVATED.getMessage(new Object[0]), database, cluster);
                    continue;
                }
                throw exception;
            }
            break;
        }
    }

    protected abstract <Z, D extends Database<Z>> D getTarget(Balancer<Z, D> var1);
}

