/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.lock.distributed;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.distributed.CommandDispatcher;
import net.sf.hajdbc.distributed.CommandDispatcherFactory;
import net.sf.hajdbc.distributed.Member;
import net.sf.hajdbc.distributed.MembershipListener;
import net.sf.hajdbc.distributed.Remote;
import net.sf.hajdbc.distributed.Stateful;
import net.sf.hajdbc.lock.LockManager;
import net.sf.hajdbc.lock.distributed.CoordinatorAcquireCommand;
import net.sf.hajdbc.lock.distributed.CoordinatorReleaseCommand;
import net.sf.hajdbc.lock.distributed.LockCommandContext;
import net.sf.hajdbc.lock.distributed.LockDescriptor;
import net.sf.hajdbc.lock.distributed.LockType;
import net.sf.hajdbc.lock.distributed.MemberAcquireLockCommand;
import net.sf.hajdbc.lock.distributed.MemberReleaseLockCommand;
import net.sf.hajdbc.lock.distributed.RemoteLockDescriptor;
import net.sf.hajdbc.util.Objects;

public class DistributedLockManager
implements LockManager,
LockCommandContext,
Stateful,
MembershipListener {
    final CommandDispatcher<LockCommandContext> dispatcher;
    private final LockManager lockManager;
    private final ConcurrentMap<Member, Map<LockDescriptor, Lock>> remoteLockDescriptorMap = new ConcurrentHashMap<Member, Map<LockDescriptor, Lock>>();

    public <Z, D extends Database<Z>> DistributedLockManager(DatabaseCluster<Z, D> cluster, CommandDispatcherFactory dispatcherFactory) throws Exception {
        this.lockManager = cluster.getLockManager();
        DistributedLockManager context = this;
        this.dispatcher = dispatcherFactory.createCommandDispatcher(cluster.getId() + ".lock", context, this, this);
    }

    @Override
    public Lock readLock(String id) {
        return this.lockManager.readLock(id);
    }

    @Override
    public Lock writeLock(String id) {
        return this.getDistibutedLock(new RemoteLockDescriptorImpl(id, LockType.WRITE, this.dispatcher.getLocal()));
    }

    @Override
    public Lock getLock(LockDescriptor lock) {
        String id = lock.getId();
        switch (lock.getType()) {
            case READ: {
                return this.lockManager.readLock(id);
            }
            case WRITE: {
                return this.lockManager.writeLock(id);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Lock getDistibutedLock(RemoteLockDescriptor descriptor) {
        return new DistributedLock(descriptor, this.getLock(descriptor), this.dispatcher);
    }

    @Override
    public void start() throws Exception {
        this.lockManager.start();
        this.dispatcher.start();
    }

    @Override
    public void stop() {
        this.dispatcher.stop();
        this.lockManager.stop();
    }

    @Override
    public Map<LockDescriptor, Lock> getRemoteLocks(Remote remote) {
        return (Map)this.remoteLockDescriptorMap.get(remote.getMember());
    }

    @Override
    public void writeState(ObjectOutput output) throws IOException {
        output.writeInt(this.remoteLockDescriptorMap.size());
        for (Map.Entry entry : this.remoteLockDescriptorMap.entrySet()) {
            output.writeObject(entry.getKey());
            Set descriptors = ((Map)entry.getValue()).keySet();
            output.writeInt(descriptors.size());
            for (LockDescriptor descriptor : descriptors) {
                output.writeUTF(descriptor.getId());
                output.writeByte(descriptor.getType().ordinal());
            }
        }
    }

    @Override
    public void readState(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = input.readInt();
        LockType[] types = LockType.values();
        for (int i = 0; i < size; ++i) {
            Member member = (Member)Objects.readObject(input);
            HashMap<RemoteLockDescriptorImpl, Lock> map = new HashMap<RemoteLockDescriptorImpl, Lock>();
            int locks = input.readInt();
            for (int j = 0; j < locks; ++j) {
                String id = input.readUTF();
                LockType type = types[input.readByte()];
                RemoteLockDescriptorImpl descriptor = new RemoteLockDescriptorImpl(id, type, member);
                Lock lock = this.getLock(descriptor);
                lock.lock();
                map.put(descriptor, lock);
            }
            this.remoteLockDescriptorMap.put(member, map);
        }
    }

    @Override
    public void added(Member member) {
        this.remoteLockDescriptorMap.putIfAbsent(member, new HashMap());
    }

    @Override
    public void removed(Member member) {
        Map locks = (Map)this.remoteLockDescriptorMap.remove(member);
        if (locks != null) {
            for (Lock lock : locks.values()) {
                lock.unlock();
            }
        }
    }

    private static class RemoteLockDescriptorImpl
    implements RemoteLockDescriptor {
        private static final long serialVersionUID = 1950781245453120790L;
        private final String id;
        private transient LockType type;
        private final Member member;

        RemoteLockDescriptorImpl(String id, LockType type, Member member) {
            this.id = id;
            this.type = type;
            this.member = member;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public LockType getType() {
            return this.type;
        }

        @Override
        public Member getMember() {
            return this.member;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeByte(this.type.ordinal());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.type = LockType.values()[in.readByte()];
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof RemoteLockDescriptor)) {
                return false;
            }
            String id = ((RemoteLockDescriptor)object).getId();
            return this.id != null && id != null ? this.id.equals(id) : this.id == id;
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }

        public String toString() {
            return String.format("%sLock(%s)", this.type.name().toLowerCase(), this.id != null ? this.id : "");
        }
    }

    private static class DistributedLock
    implements Lock {
        private final RemoteLockDescriptor descriptor;
        private final Lock lock;
        private final CommandDispatcher<LockCommandContext> dispatcher;

        DistributedLock(RemoteLockDescriptor descriptor, Lock lock, CommandDispatcher<LockCommandContext> dispatcher) {
            this.descriptor = descriptor;
            this.lock = lock;
            this.dispatcher = dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            boolean locked = false;
            while (!locked) {
                if (this.dispatcher.isCoordinator()) {
                    this.lock.lock();
                    try {
                        locked = this.lockMembers();
                    }
                    finally {
                        if (!locked) {
                            this.lock.unlock();
                        }
                    }
                } else {
                    locked = this.lockCoordinator(Long.MAX_VALUE);
                }
                if (locked) continue;
                Thread.yield();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lockInterruptibly() throws InterruptedException {
            boolean locked = false;
            while (!locked) {
                if (this.dispatcher.isCoordinator()) {
                    this.lock.lockInterruptibly();
                    try {
                        locked = this.lockMembers();
                    }
                    finally {
                        if (!locked) {
                            this.lock.unlock();
                        }
                    }
                } else {
                    locked = this.lockCoordinator(Long.MAX_VALUE);
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (locked) continue;
                Thread.yield();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock() {
            boolean locked = false;
            if (this.dispatcher.isCoordinator()) {
                if (this.lock.tryLock()) {
                    try {
                        locked = this.lockMembers();
                    }
                    finally {
                        if (!locked) {
                            this.lock.unlock();
                        }
                    }
                }
            } else {
                locked = this.lockCoordinator(0L);
            }
            return locked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            boolean locked = false;
            if (this.dispatcher.isCoordinator()) {
                if (this.lock.tryLock(time, unit)) {
                    try {
                        locked = this.lockMembers();
                    }
                    finally {
                        if (!locked) {
                            this.lock.unlock();
                        }
                    }
                }
            } else {
                locked = this.lockCoordinator(unit.toMillis(time));
            }
            return locked;
        }

        private boolean lockMembers() {
            boolean locked = true;
            Map<Member, Boolean> results = this.dispatcher.executeAll(new MemberAcquireLockCommand(this.descriptor));
            for (Map.Entry<Member, Boolean> entry : results.entrySet()) {
                locked &= entry.getValue().booleanValue();
            }
            if (!locked) {
                this.unlockMembers();
            }
            return locked;
        }

        private boolean lockCoordinator(long timeout) {
            return this.dispatcher.executeCoordinator(new CoordinatorAcquireCommand(this.descriptor, timeout));
        }

        @Override
        public void unlock() {
            if (this.dispatcher.isCoordinator()) {
                this.unlockMembers();
                this.lock.unlock();
            } else {
                this.unlockCoordinator();
            }
        }

        private void unlockMembers() {
            this.dispatcher.executeAll(new MemberReleaseLockCommand(this.descriptor));
        }

        private void unlockCoordinator() {
            this.dispatcher.executeCoordinator(new CoordinatorReleaseCommand(this.descriptor));
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

