/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.lock.semaphore;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class SemaphoreLock
implements Lock {
    private final Semaphore semaphore;

    public SemaphoreLock(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    @Override
    public void lock() {
        this.semaphore.acquireUninterruptibly();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.semaphore.acquire();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        return this.semaphore.tryAcquire();
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.semaphore.tryAcquire(time, unit);
    }

    @Override
    public void unlock() {
        this.semaphore.release();
    }
}

