/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.lock.semaphore;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import net.sf.hajdbc.lock.LockManager;
import net.sf.hajdbc.lock.semaphore.SemaphoreReadWriteLock;

public class SemaphoreLockManager
implements LockManager {
    private final ConcurrentMap<String, ReadWriteLock> lockMap = new ConcurrentHashMap<String, ReadWriteLock>();
    private final boolean fair;

    public SemaphoreLockManager(boolean fair) {
        this.fair = fair;
    }

    @Override
    public Lock readLock(String object) {
        Lock lock = this.getReadWriteLock(null).readLock();
        return object == null ? lock : new GlobalLock(lock, this.getReadWriteLock(object).readLock());
    }

    @Override
    public Lock writeLock(String object) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(null);
        return object == null ? readWriteLock.writeLock() : new GlobalLock(readWriteLock.readLock(), this.getReadWriteLock(object).writeLock());
    }

    private synchronized ReadWriteLock getReadWriteLock(String object) {
        ReadWriteLock existing;
        String key = object != null ? object : "";
        ReadWriteLock lock = (ReadWriteLock)this.lockMap.get(key);
        if (lock == null && (existing = this.lockMap.putIfAbsent(key, lock = new SemaphoreReadWriteLock(new Semaphore(Integer.MAX_VALUE, this.fair)))) != null) {
            lock = existing;
        }
        return lock;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() {
    }

    private static class GlobalLock
    implements Lock {
        private Lock globalLock;
        private Lock lock;

        GlobalLock(Lock globalLock, Lock lock) {
            this.globalLock = globalLock;
            this.lock = lock;
        }

        @Override
        public void lock() {
            this.globalLock.lock();
            this.lock.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.globalLock.lockInterruptibly();
            try {
                this.lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                this.globalLock.unlock();
                throw e;
            }
        }

        @Override
        public boolean tryLock() {
            if (this.globalLock.tryLock()) {
                if (this.lock.tryLock()) {
                    return true;
                }
                this.globalLock.unlock();
            }
            return false;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            if (this.globalLock.tryLock(time, unit)) {
                if (this.lock.tryLock(time, unit)) {
                    return true;
                }
                this.globalLock.unlock();
            }
            return false;
        }

        @Override
        public void unlock() {
            this.lock.unlock();
            this.globalLock.unlock();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

