/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.lock.semaphore;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import net.sf.hajdbc.lock.semaphore.SemaphoreLock;

public class SemaphoreReadWriteLock
implements ReadWriteLock {
    private final Lock readLock;
    private final Lock writeLock;

    public SemaphoreReadWriteLock(Semaphore semaphore) {
        this.readLock = new SemaphoreLock(semaphore);
        this.writeLock = new SemaphoreWriteLock(semaphore);
    }

    @Override
    public Lock readLock() {
        return this.readLock;
    }

    @Override
    public Lock writeLock() {
        return this.writeLock;
    }

    private static class SemaphoreWriteLock
    implements Lock {
        private final Semaphore semaphore;
        private final int permits;

        SemaphoreWriteLock(Semaphore semaphore) {
            this.semaphore = semaphore;
            this.permits = semaphore.availablePermits();
        }

        private int drainPermits() {
            return this.semaphore.isFair() ? 0 : this.semaphore.drainPermits();
        }

        @Override
        public void lock() {
            int drained = this.drainPermits();
            if (drained < this.permits) {
                this.semaphore.acquireUninterruptibly(this.permits - drained);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            int drained = this.drainPermits();
            if (drained < this.permits) {
                try {
                    this.semaphore.acquire(this.permits - drained);
                }
                catch (InterruptedException e) {
                    if (drained > 0) {
                        this.semaphore.release(drained);
                    }
                    throw e;
                }
            }
        }

        @Override
        public boolean tryLock() {
            return this.semaphore.tryAcquire(this.permits);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            int drained = this.drainPermits();
            if (drained == this.permits) {
                return true;
            }
            boolean acquired = false;
            try {
                acquired = this.semaphore.tryAcquire(this.permits - drained, timeout, unit);
            }
            finally {
                if (!acquired && drained > 0) {
                    this.semaphore.release(drained);
                }
            }
            return acquired;
        }

        @Override
        public void unlock() {
            this.semaphore.release(this.permits);
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

