/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.logging;

import java.util.ServiceLoader;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggingProvider;

public final class LoggerFactory {
    private static final LoggingProvider provider = LoggerFactory.getProvider();

    private static LoggingProvider getProvider() {
        for (LoggingProvider provider : ServiceLoader.load(LoggingProvider.class, LoggingProvider.class.getClassLoader())) {
            if (!provider.isEnabled()) continue;
            provider.getLogger(LoggerFactory.class).log(Level.DEBUG, "Using {0} logging", provider.getName());
            return provider;
        }
        throw new IllegalStateException(String.format("No %s found", LoggingProvider.class.getName()));
    }

    public static Logger getLogger(Class<?> targetClass) {
        return provider.getLogger(targetClass);
    }

    private LoggerFactory() {
    }
}

