/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.logging.commons;

import net.sf.hajdbc.logging.AbstractLogger;
import net.sf.hajdbc.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsLogger
extends AbstractLogger {
    private final Log log;

    public CommonsLogger(Class<?> targetClass) {
        this.log = LogFactory.getLog(targetClass);
    }

    @Override
    public void log(Level level, Throwable e, String pattern, Object ... args) {
        switch (level) {
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                String message = CommonsLogger.format(pattern, args);
                if (e != null) {
                    this.log.error((Object)message, e);
                    break;
                }
                this.log.error((Object)message);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                String message = CommonsLogger.format(pattern, args);
                if (e != null) {
                    this.log.warn((Object)message, e);
                    break;
                }
                this.log.warn((Object)message);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                String message = CommonsLogger.format(pattern, args);
                if (e != null) {
                    this.log.info((Object)message, e);
                    break;
                }
                this.log.info((Object)message);
                break;
            }
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                String message = CommonsLogger.format(pattern, args);
                if (e != null) {
                    this.log.debug((Object)message, e);
                    break;
                }
                this.log.debug((Object)message);
                break;
            }
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                String message = CommonsLogger.format(pattern, args);
                if (e != null) {
                    this.log.trace((Object)message, e);
                    break;
                }
                this.log.trace((Object)message);
            }
        }
    }
}

