/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.logging.jdk;

import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.hajdbc.logging.AbstractLogger;
import net.sf.hajdbc.logging.Level;

public class JDKLogger
extends AbstractLogger {
    private static final Map<Level, java.util.logging.Level> levels = new EnumMap<Level, java.util.logging.Level>(Level.class);
    private final Logger logger;

    public JDKLogger(Class<?> targetClass) {
        this.logger = Logger.getLogger(targetClass.getName());
    }

    @Override
    public void log(Level level, Throwable e, String pattern, Object ... args) {
        java.util.logging.Level realLevel = levels.get((Object)level);
        if (this.logger.isLoggable(realLevel)) {
            String message = JDKLogger.format(pattern, args);
            if (e != null) {
                this.logger.log(realLevel, message, e);
            } else {
                this.logger.log(realLevel, message);
            }
        }
    }

    static {
        levels.put(Level.ERROR, java.util.logging.Level.SEVERE);
        levels.put(Level.WARN, java.util.logging.Level.WARNING);
        levels.put(Level.INFO, java.util.logging.Level.INFO);
        levels.put(Level.DEBUG, java.util.logging.Level.FINE);
        levels.put(Level.TRACE, java.util.logging.Level.FINEST);
    }
}

